/**********************************************************************
*
* util
*
* ӿ
*
* Copyright 2020 HuaWei, Inc.
*
**********************************************************************/

#include <Windows.h>
#include "json.h"
#include <napi.h>

#ifndef _UTIL_H_
#define _UTIL_H_


class Util
{
public:
    Util();
    ~Util();

private:
    static std::string exeName;

public:
    static std::string multiByte2UTF8(const std::string & str);
    static std::string GetAppDataPath();
    static std::string GetExeName() {return exeName;}

    static std::string DesensitiveStr(const std::string& orgStr);
    /* ȫӡͺ */
    static std::string SafePrintNameOrNumber(const std::string& srcString, bool isNumber = false);
    /* ȫӡip */
    static std::string SafePrintIp(const std::string& inputString);
    /* ȫӡpath */
    static std::string SafePrintPath(const std::string& inputString);
    /* ȫӡaccount */
    static std::string SafePrintAccount(const std::string& inputString);

    static bool IsIPv4(std::string ip);

    static std::vector<std::string> Split(const std::string& str, const std::string& delim); 

    static std::wstring UTF8ToWideChar(const std::string str );

    static std::string UnicodeToUTF8(const std::wstring& wstr);

    static int CopyJsonStr(char* dst, unsigned int dstSize, const Json::Value& root)
    {
        return Util::SeucreCopyStr(dst, dstSize, root.isString() ? root.asString().c_str() : "");
    }
    static bool GetJsonBool(const Json::Value& root, bool defaultValue = false)
    {
        return root.isConvertibleTo(Json::booleanValue) ? root.asBool() : defaultValue;
    }
    static int GetJsonInt(const Json::Value& root, int defaultValue = 0)
    {
        return root.isInt()? root.asInt() : defaultValue;
    }
    static uint32_t GetJsonUInt(const Json::Value& root, uint32_t defaultValue = 0)
    {
        return root.isUInt() ? root.asUInt() : defaultValue;
    }
    static int64_t GetJsonInt64(const Json::Value& root, int64_t defaultValue = 0)
    {
        return root.isInt64()? root.asInt64() : defaultValue;
    }
    static uint64_t GetJsonUInt64(const Json::Value& root, uint64_t defaultValue = 0)
    {
        return root.isUInt64()? root.asUInt64() : defaultValue;
    }
    static double GetJsonDouble(const Json::Value& root, double defaultValue = 0)
    {
        return root.isDouble() ? root.asDouble() : defaultValue;
    }
    static Json::String GetJsonString(const Json::Value& root, Json::String defaultValue = "")
    {
        return root.isString() ? root.asString() : defaultValue;
    }
    static int SeucreCopyStr(char* dst,unsigned int dstLen,const char* src);
    static std::string AnsiToUTF8(const std::string& str);
    static std::string WChar2Ansi(LPCWSTR pwszSrc);
    static std::string Json2String(const Json::Value& json);
    static napi_value CharToUint8Array(Napi::Env env, const char* data, size_t length);
};


#endif
