import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class DisableVoicePrompts extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isDisableMutePrompt: false,
    }
  }

  changeIsDisableMutePrompt (e) {
    this.setState({
      isDisableMutePrompt: e.target.checked,
    })
  }

  async goDisableVoicePrompts () {
    const { isDisableMutePrompt } = this.state
    const param = {
      isDisableMutePrompt,
    }
    const apiService = new ApiService()
    const setResult = await apiService.disableVoicePrompts(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="area">
                 <div className="input-box">
                    <div className="input-box-title-check">Disable Mute Prompt:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.isDisableMutePrompt} onChange={this.changeIsDisableMutePrompt.bind(this)} /></div>
                </div>
                <button onClick={this.goDisableVoicePrompts.bind(this)}>Submit</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default DisableVoicePrompts
