import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { showErrorTips } from '../../../../utils'

class RenameSelf extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      nickName: '',
    }
  }

  changeNickName (e) {
    this.setState({
      nickName: e.target.value,
    })
  }

  async goToRenameSelf () {
    const { nickName } = this.state
    const param = {
      nickName,
    }
    const apiService = new ApiService()
    const setResult = await apiService.renameSelf(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="renameSelf">
        <div className="input-box">
          <div className="input-box-title">NickName:</div>
          <div className="input-box-text">
            <input value={this.state.nickName} onChange={this.changeNickName.bind(this)}/>
          </div>
        </div>
        <button onClick={this.goToRenameSelf.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default RenameSelf
