import React from 'react'
import './index.less'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'
import { SDKERR } from 'hwmsdk-electron/ts/Api/enum'

class StartProjection extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      pairCode: '',
      randomNumber: '',
      verifyCode: '',
    }
  }

  changePairCode (e) {
    this.setState({
      pairCode: e.target.value,
    })
  }

  changeRandomNumber (e) {
    this.setState({
      randomNumber: e.target.value,
    })
  }

  changeVerifyCode (e) {
    this.setState({
      verifyCode: e.target.value,
    })
  }

  async startProjection () {
    const { pairCode, randomNumber, verifyCode } = this.state
    const param = {
      pairCode,
      randomNumber,
      verifyCode,
    }
    const apiService = new ApiService()
    const setResult = await apiService.startProjection(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)

      // 错误码为USG_PROJECTION_CROSS_CORP时，自动填充RandomNumber，等待输入二次验证码
      if (setResult.ret === SDKERR.USG_PROJECTION_CROSS_CORP) {
        this.setState({
          randomNumber: setResult.startProjectionResult.randomNumber,
        })
      }
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="startProjection">
        <div className="input-box">
          <div className="input-box-title">Pair Code:</div>
          <div className="input-box-text">
            <input
              className="input-text"
              value={this.state.pairCode}
              onChange={this.changePairCode.bind(this)}
            />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Random Number:</div>
          <div className="input-box-text">
            <input
              className="input-text"
              value={this.state.randomNumber}
              onChange={this.changeRandomNumber.bind(this)}
            />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">Verify Code:</div>
          <div className="input-box-text">
            <input
              className="input-text"
              value={this.state.verifyCode}
              onChange={this.changeVerifyCode.bind(this)}
            />
          </div>
        </div>
        <button onClick={this.startProjection.bind(this)}>Start</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default StartProjection
