import { SDKERR, ConfRole, LocalRecordOperateType, TargetLanguageType, UserState } from './enum';
import { StartProjectionParam, JoinConfByIdInfo, CreateConfResult, StartShareInfo, LocalRecordStatusInfo, CreateConfInfo, ConfStateInfo, AcceptConfParam, ConfEndInfo, RecvShareStateInfo, AddAttendeeInfo, SelfShareStateInfo, AutoHideToolBarParam, StartCallInfo, AttendeeListInfo, TargetLanguageTypeList, InterruptInfo, JoinConfByRandomInfo, RealTimeSubtitleInfo, LocalRecordStateInfo, PoorNetWorkQualityInfo, LocalRecordPermissionInfo, MeetingInfo, ConfInfo, SubtitleRecordInfo, RenameSelfInfo, StartProjectionResult, AddAttendeeResultList, P2PConfRecordInfo, ShareStateInfo } from './model';
export declare class IConfCtrl {
    addOn: IConfCtrl;
    _onConfStateChangedCallback: (confStateInfo: ConfStateInfo) => void;
    _onConfEndedNotifyCallback: (confEndInfo: ConfEndInfo) => void;
    _onP2PConfRecordNotifyCallback: (recordInfo: P2PConfRecordInfo) => void;
    _onConfInfoNotifyCallback: (confInfo: ConfInfo) => void;
    _onShareStateChangedCallback: (shareStateInfo: ShareStateInfo) => void;
    _onRecvShareStateChangedCallback: (shareStateInfo: RecvShareStateInfo) => void;
    _onSelfRoleChangedCallback: (role: ConfRole) => void;
    _onPoorNetworkQualityInfoNotifyCallback: (poorNetWorkInfo: PoorNetWorkQualityInfo) => void;
    _onMeetingInfoChangedCallback: (meetingInfo: MeetingInfo) => void;
    _onWaitingListChangedCallback: (waitingList: AttendeeListInfo) => void;
    _onAddAttendeeNotifyCallback: (addAttendeeResultList: AddAttendeeResultList) => void;
    _onSelfLocalRecordStateNotifyCallback: (localRecordStateInfo: LocalRecordStateInfo) => void;
    _onAttendeeListChangedCallback: (attendeeList: AttendeeListInfo) => void;
    _onRealTimeSubtitleInfoNotifyCallback: (realTimeSubtitleInfo: RealTimeSubtitleInfo) => void;
    _onSubtitleRecordNotifyCallback: (subtitleRecordInfo: SubtitleRecordInfo) => void;
    _onSubtitleStateChangedCallback: (isOpen: boolean) => void;
    _onWaitingRoomStateChangedCallback: (isOpen: boolean) => void;
    _onStartLocalRecordOperationInterruptNotifyCallback: (info: InterruptInfo) => void;
    _createConfCallback: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void;
    _startP2pConfCallback: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void;
    _joinConfByIdCallback: (ret: SDKERR, reason: string) => void;
    _joinConfByRandomCallback: (ret: SDKERR, reason: string) => void;
    _addAttendeeCallback: (ret: SDKERR, reason: string) => void;
    _leaveConfCallback: (ret: SDKERR, reason: string) => void;
    _endConfCallback: (ret: SDKERR, reason: string) => void;
    _startShareCallback: (ret: SDKERR, reason: string) => void;
    _stopShareCallback: (ret: SDKERR, reason: string) => void;
    _getAttendeeListCallback: (ret: SDKERR, reason: string, attendeeList: AttendeeListInfo) => void;
    _getAudienceListCallback: (ret: SDKERR, reason: string, audidenceList: AttendeeListInfo) => void;
    _getUserStateCallback: (ret: SDKERR, reason: string, userState: UserState) => void;
    _getSelfRoleCallback: (ret: SDKERR, reason: string, selfRole: ConfRole) => void;
    _renameSelfCallback: (ret: SDKERR, reason: string) => void;
    _startProjectionCallback: (ret: SDKERR, reason: string, startProjectionResult: StartProjectionResult) => void;
    _acceptConfCallback: (ret: SDKERR, reason: string) => void;
    _rejectConfCallback: (ret: SDKERR, reason: string) => void;
    _getSelfShareStateCallback: (ret: SDKERR, reason: string, selfShareStateInfo: SelfShareStateInfo) => void;
    _openSubtitleCallback: (ret: SDKERR, reason: string, isOpen: boolean) => void;
    _openWaitingRoomCallback: (ret: SDKERR, reason: string, isOpen: boolean) => void;
    _operateLocalRecordCallback: (ret: SDKERR, reason: string, type: LocalRecordOperateType) => void;
    _openVirtualBackgroundSettingPageCallback: (ret: SDKERR, reason: string) => void;
    _getConfLocalRecordStatusCallback: (ret: SDKERR, reason: string, state: LocalRecordStatusInfo) => void;
    _getSelfHasLocalRecordPermissionCallback: (ret: SDKERR, reason: string, permission: LocalRecordPermissionInfo) => void;
    _requestLocalRecordPermissionCallback: (ret: SDKERR, reason: string) => void;
    _applyHostRoleCallback: (ret: SDKERR, reason: string) => void;
    _getSubtitlePageOpenedCallback: (ret: SDKERR, reason: string, isOpen: boolean) => void;
    _getWaitingRoomOpenedCallback: (ret: SDKERR, reason: string, isOpen: boolean) => void;
    _getVirtualBackgroundSettingPageOpenedCallback: (ret: SDKERR, reason: string, isOpen: boolean) => void;
    _subscribeSubtitleLanguageCallback: (ret: SDKERR, reason: string, targetLanguageType: TargetLanguageType) => void;
    _subscribeSubtitleCallback: (ret: SDKERR, reason: string, isSubscirbe: boolean) => void;
    _getSubtitleSupportLanguageCallback: (ret: SDKERR, reason: string, targetLanguageTypeList: TargetLanguageTypeList) => void;
    _inProcessCallbackSet: Set<string>;
    callWithIPC: boolean;
    constructor(addOn: IConfCtrl);
    init(): void;
    /**
    * [en] Notify of conf state. [cn] 会议状态通知
    */
    setOnConfStateChangedCB(onConfStateChanged: (confStateInfo: ConfStateInfo) => void): void;
    /**
    * [en] This class is about the notification of an ended conference. [cn] 会议结束通知
    */
    setOnConfEndedNotifyCB(onConfEndedNotify: (confEndInfo: ConfEndInfo) => void): void;
    /**
    * [en] This class is about the callback of transfering point to point call to conference. [cn] 立即会议记录回调
    */
    setOnP2PConfRecordNotifyCB(onP2PConfRecordNotify: (recordInfo: P2PConfRecordInfo) => void): void;
    /**
    * [en] Notify of conf info. [cn] 会议信息通知
    */
    setOnConfInfoNotifyCB(onConfInfoNotify: (confInfo: ConfInfo) => void): void;
    /**
    * [en] Notify of share state. [cn] 共享状态通知
    */
    setOnShareStateChangedCB(onShareStateChanged: (shareStateInfo: ShareStateInfo) => void): void;
    /**
    * [en] Notify of receive share state. [cn] 收到共享状态通知
    */
    setOnRecvShareStateChangedCB(onRecvShareStateChanged: (shareStateInfo: RecvShareStateInfo) => void): void;
    /**
    * [en] Self role changed. [cn] 个人角色变化通知
    */
    setOnSelfRoleChangedCB(onSelfRoleChanged: (role: ConfRole) => void): void;
    /**
    * [en] This class is about the notification of low quality network. [cn] 弱网提示通知
    */
    setOnPoorNetworkQualityInfoNotifyCB(onPoorNetworkQualityInfoNotify: (poorNetWorkInfo: PoorNetWorkQualityInfo) => void): void;
    /**
    * [en]Notify of conf info [cn]会中信息更新通知
    */
    setOnMeetingInfoChangedCB(onMeetingInfoChanged: (meetingInfo: MeetingInfo) => void): void;
    /**
    * [en] Notify of the waiting list [cn] 等候室成员列表变更的通知
    */
    setOnWaitingListChangedCB(onWaitingListChanged: (waitingList: AttendeeListInfo) => void): void;
    /**
    * [en] Notify of the add attendee [cn] 添加与会者结果通知
    */
    setOnAddAttendeeNotifyCB(onAddAttendeeNotify: (addAttendeeResultList: AddAttendeeResultList) => void): void;
    /**
    * [en] Notify of local record state [cn] 本地录制状态通知
    */
    setOnSelfLocalRecordStateNotifyCB(onSelfLocalRecordStateNotify: (localRecordStateInfo: LocalRecordStateInfo) => void): void;
    /**
    * [en] Notify of the attendee list [cn] 与会者列表变更的通知
    */
    setOnAttendeeListChangedCB(onAttendeeListChanged: (attendeeList: AttendeeListInfo) => void): void;
    /**
    * [en] Notify of the real time subtitle info [cn] 实时字幕信息的通知
    */
    setOnRealTimeSubtitleInfoNotifyCB(onRealTimeSubtitleInfoNotify: (realTimeSubtitleInfo: RealTimeSubtitleInfo) => void): void;
    /**
    * [en] Notify of the subtitle record info [cn] 字幕记录消息的通知
    */
    setOnSubtitleRecordNotifyCB(onSubtitleRecordNotify: (subtitleRecordInfo: SubtitleRecordInfo) => void): void;
    /**
    * [en] Notify of subtitle state change [cn] 字幕状态变更通知
    */
    setOnSubtitleStateChangedCB(onSubtitleStateChanged: (isOpen: boolean) => void): void;
    /**
    * [en] Notify of waiting room state change [cn] 等候室状态变更通知
    */
    setOnWaitingRoomStateChangedCB(onWaitingRoomStateChanged: (isOpen: boolean) => void): void;
    /**
    * [en] Notify of local record operation interrupt notify [cn] 本地录制操作中断通知
    */
    setOnStartLocalRecordOperationInterruptNotifyCB(onStartLocalRecordOperationInterruptNotify: (info: InterruptInfo) => void): void;
    /**
    * [en] This interface is used to create conf. [cn] 创建会议
    */
    createConf(createConfInfo: CreateConfInfo, onCreateConfResult?: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void): void;
    /**
    * [en] This interface is used to start p2p conf. [cn] 发起立即会议
    */
    startP2pConf(startCallInfo: StartCallInfo, onStartP2pConfResult?: (ret: SDKERR, reason: string, createConfResult: CreateConfResult) => void): void;
    /**
    * [en] This interface is used to join conf by id. [cn] 加入会议
    */
    joinConfById(joinConfByIdInfo: JoinConfByIdInfo, onJoinConfByIdResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to join conf by random. [cn] Random入会
    */
    joinConfByRandom(joinConfByRandomInfo: JoinConfByRandomInfo, onJoinConfByRandomResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to add attendee. [cn] 添加与会者
    */
    addAttendee(addAttendeeInfo: AddAttendeeInfo, onAddAttendeeResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to leave conf. [cn] 离开会议
    */
    leaveConf(onLeaveConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to end conf. [cn] 结束会议
    */
    endConf(onEndConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to start share. [cn] 开启共享
    */
    startShare(startShareInfo: StartShareInfo, onStartShareResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to stop share. [cn] 结束共享
    */
    stopShare(onStopShareResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get attendee List. [cn] 获取与会者列表
    */
    getAttendeeList(onGetAttendeeListResult?: (ret: SDKERR, reason: string, attendeeList: AttendeeListInfo) => void): void;
    /**
    * [en] This interface is used to get audience List. [cn] 获取观众列表
    */
    getAudienceList(onGetAudienceListResult?: (ret: SDKERR, reason: string, audidenceList: AttendeeListInfo) => void): void;
    /**
    * [en] This interface is used to get user state. [cn] 获取用户状态
    */
    getUserState(onGetUserStateResult?: (ret: SDKERR, reason: string, userState: UserState) => void): void;
    /**
    * [en] This interface is used to get self role. [cn] 获取自己会中角色
    */
    getSelfRole(onGetSelfRoleResult?: (ret: SDKERR, reason: string, selfRole: ConfRole) => void): void;
    /**
    * [en] This interface is used to rename self. [cn] 设置会场名
    */
    renameSelf(renameSelfInfo: RenameSelfInfo, onRenameSelfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to start projection. [cn] 发起投屏
    */
    startProjection(startProjectionParam: StartProjectionParam, onStartProjectionResult?: (ret: SDKERR, reason: string, startProjectionResult: StartProjectionResult) => void): void;
    /**
    * [en] This interface is used to set auto hide tool bar. [cn] 设置会控栏自动隐藏
    */
    setAutoHideToolBar(autoHideToolBarParam: AutoHideToolBarParam): SDKERR;
    /**
    * [en] This interface is used to accept conf. [cn] 接受会议邀请
    */
    acceptConf(acceptConfParam: AcceptConfParam, onAcceptConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to reject conf. [cn] 拒绝会议邀请
    */
    rejectConf(onRejectConfResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get self share state. [cn] 获取自己的开启共享状态
    */
    getSelfShareState(onGetSelfShareStateResult?: (ret: SDKERR, reason: string, selfShareStateInfo: SelfShareStateInfo) => void): void;
    /**
    * [en] This interface is used to operate subtitle. [cn] 开启/关闭字幕
    */
    openSubtitle(isOpen: boolean, onOpenSubtitleResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void;
    /**
    * [en] This interface is used to operate waiting room. [cn] 开启/关闭等候室
    */
    openWaitingRoom(isOpen: boolean, onOpenWaitingRoomResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void;
    /**
    * [en] This interface is used to operate local record. [cn] 操作本地录制
    */
    operateLocalRecord(type: LocalRecordOperateType, onOperateLocalRecordResult?: (ret: SDKERR, reason: string, type: LocalRecordOperateType) => void): void;
    /**
    * [en] This interface is used to open virtual background setting page. [cn] 打开虚拟背景设置
    */
    openVirtualBackgroundSettingPage(onOpenVirtualBackgroundSettingPageResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get local record status. [cn] 获取本地录制状态
    */
    getConfLocalRecordStatus(onGetConfLocalRecordStatusResult?: (ret: SDKERR, reason: string, state: LocalRecordStatusInfo) => void): void;
    /**
    * [en] This interface is used to get local record permission. [cn] 获取本地录制权限
    */
    getSelfHasLocalRecordPermission(onGetSelfHasLocalRecordPermissionResult?: (ret: SDKERR, reason: string, permission: LocalRecordPermissionInfo) => void): void;
    /**
    * [en] This interface is used to request local record permission. [cn] 申请本地录制权限
    */
    requestLocalRecordPermission(onRequestLocalRecordPermissionResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to request host role. [cn] 申请主持人
    */
    applyHostRole(password: string, onApplyHostRoleResult?: (ret: SDKERR, reason: string) => void): void;
    /**
    * [en] This interface is used to get subtitle state. [cn] 获取字幕状态
    */
    getSubtitlePageOpened(onGetSubtitlePageOpenedResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void;
    /**
    * [en] This interface is used to get waiting room state. [cn] 获取等候室状态
    */
    getWaitingRoomOpened(onGetWaitingRoomOpenedResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void;
    /**
    * [en] This interface is used to get virtual background setting page state. [cn] 获取是否已经打开虚拟背景设置
    */
    getVirtualBackgroundSettingPageOpened(onGetVirtualBackgroundSettingPageOpenedResult?: (ret: SDKERR, reason: string, isOpen: boolean) => void): void;
    /**
    * [en] This interface is used to subscribe subtitle language. [cn] 订阅字幕语言
    */
    subscribeSubtitleLanguage(targetLanguageType: TargetLanguageType, onSubscribeSubtitleLanguageResult?: (ret: SDKERR, reason: string, targetLanguageType: TargetLanguageType) => void): void;
    /**
    * [en] This interface is used to subscribe subtitle. [cn] 订阅/取消订阅字幕
    */
    subscribeSubtitle(isSubscribe: boolean, onSubscribeSubtitleResult?: (ret: SDKERR, reason: string, isSubscirbe: boolean) => void): void;
    /**
    * [en] This interface is used to get subtitle support languagues. [cn] 获取字幕支持的语言
    */
    getSubtitleSupportLanguage(onGetSubtitleSupportLanguageResult?: (ret: SDKERR, reason: string, targetLanguageTypeList: TargetLanguageTypeList) => void): void;
}
