//
//  HWMSocialShareHandler.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/11/10.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "HWMConfStateInfo.h"

NS_ASSUME_NONNULL_BEGIN

/// 两个接口只需要实现一个 若两个都实现，只会取 showSocialShareView: shareInfo
@protocol HWMSocialShareHandler <NSObject>
@optional

/// 会中鼠标至于标题栏出现的分享View 大小外部指定,显示位置, 内部指定; 显示、隐藏时机内部控制
/// 注入过一次后，此次会议中内部会保留此对象，外部可以结合onConfInfoNotify数据驱动在此NSView对象上进行view的视图改变（原生实现使用此接口 方便简单)
/// @param confInfo 会中会议状态详情
- (NSView *)socialShareView:(HWMConfStateInfo *)confInfo DEPRECATED_MSG_ATTRIBUTE("可通过HWMShowSocialShareHandler实现，该接口已废弃");

/// 会中鼠标至标题出现分享View 全部外部控制：大小，显示位置、显示隐藏时机等    (JS显示可以使用此接口)
/// @param point 鼠标位置
/// @param confInfo 会中会议状态详情
- (void)showSocialShareView:(NSPoint)point shareInfo:(HWMConfStateInfo *)confInfo DEPRECATED_MSG_ATTRIBUTE("可通过HWMShowSocialShareHandler实现，该接口已废弃");

@end

NS_ASSUME_NONNULL_END
