//
//  HWMOpenApi.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/9.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"
#import "HWMAppIDLoginParam.h"
#import "HWMCreateConfParam.h"
#import "HWMJoinConfParam.h"
#import "HWMRandomConfParam.h"
#import "HWMOrderConfParam.h"
#import "HWMStartCallParam.h"
#import "HWMLinkConfParam.h"
#import "HWMSSOLoginParam.h"
#import "HWMUISDKStartCallInfoModel.h"
#import "HWMUISDKStartProjectionParamModel.h"
#import "HWMUISDKCAVerifyInfoModel.h"
#import "HWMUISDKCustomSceneTextInfoListModel.h"
#import "HWMUISDKAcceptConfParamModel.h"
#import "HWMUISDKTransparentWndInfoModel.h"
#import "HWMVirtualBackgroundParam.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMOpenApi : NSObject

/// 登录接口
/// @param account 账号
/// @param password 密码
/// @param callback 结果回调，返回登录用户的UUID
- (void)login:(NSString *_Nonnull)account password:(NSString *_Nonnull)password callback:(_Nonnull HWMSDKLoginCompleteHandler)callback;

/// 登录接口
/// @param appidInfo 使用APPID登录的信息
/// @param callback 结果回调，返回登录用户的UUID
- (void)login:(HWMAppIDLoginParam *)appidInfo callback:(HWMSDKLoginCompleteHandler)callback;

/// SSO登录接口
/// @param param SSO登录的信息
/// @param callback 结果回调
- (void)loginBySSO:(HWMSSOLoginParam *)param callback:(HWMSDKLoginCompleteHandler)callback;

/// 登出
/// @param callback 结果回调
- (void)logout:(_Nonnull HWMSDKLogoutCompletehandler)callback;

/// 创建会议
/// @param param 创会参数， 详见 HWMCreateConfParam
/// @param callback 结果回调
- (void)createConf:(HWMCreateConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCreateConfCompleteHandler)callback;

/// 会议ID、密码方式加入会议
/// @param param 入会参数，详见 HWMJoinConfParam
/// @param callback 结果回调
- (void)joinConfByPassword:(HWMJoinConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 会议ID、random方式加入会议
/// @param param 入会参数，详见 HWMRandomConfParam
/// @param callback 结果回调
- (void)joinConfByRandom:(HWMRandomConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 发起呼叫（可以通过发起立即会议实现，该接口即将废弃）
/// @param param 呼叫参数，详见 HWMStartCallParam
/// @param callback 结果回调
- (void)startCall:(HWMStartCallParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback DEPRECATED_ATTRIBUTE;

/// 发起立即会议
/// @param param 创会参数，详见 HWMUISDKStartCallInfoModel
/// @param callback 结果回调
- (void)startP2PConf:(HWMUISDKStartCallInfoModel *_Nonnull)param callback:(_Nonnull HWMSDKCreateConfCompleteHandler)callback;

/// 发起投屏
/// @param param 投屏参数，详见 HWMUISDKStartProjectionParamModel
/// @param callback 结果回调
- (void)startProjectionWithParam:(HWMUISDKStartProjectionParamModel *)param callback:(HWMSDKStartProjectionCompleteHandler)callback;

/// 接受会议邀请
/// @param param isAudioAccept:是否语音接听（仅点对点视频会议生效）
/// @param callback 结果回调
- (void)acceptConfWithParam:(HWMUISDKAcceptConfParamModel *)param callback:(HWMSDKCompleteHandler)callback;

/// 拒绝会议邀请
/// @param callback 结果回调
- (void)rejectConfWithCallback:(HWMSDKCompleteHandler)callback;

/// 获取点对点呼叫状态（该接口即将废弃）
- (HWMCallStatus)getCallStatus DEPRECATED_ATTRIBUTE;

/// 查询是否在会中
- (HWMUserState)getUserState;

/// 查询pstn number，用于会议分享
- (NSString *)getConfPstnAccessNumber;

/// 设置水印
- (void)setWaterMark:(nullable NSAttributedString *)waterMarkString;

/// 设置本地录制的文件路径
/// 如果不设置，默认使用 ~/Downloads/LocalRecordFiles 文件夹，若APP开启了沙盒，需要开启沙盒下载文件夹读写权限。
/// Note：传入的URL必须要有可写权限，否则本地录制文件会保存失败
/// 如果传入的URL是沙盒路径，无需特殊处理，如果是通过savePanel等选择的路径，则需要接入方通过bookmark 缓存文件权限信息，以便杀进程再次打开还有可写权限。
/// bookmark相关详见苹果NSURLBookmarkResolutionWithSecurityScope
/// 如果设置为空，则使用默认路径
/// @param filePathUrl 文件路径URL
- (void)setLocalRecordPath:(NSURL *)filePathUrl;

/// 获取当前本地录制文件夹路径
/// 如果设置的路径被删除，会返回默认的路径
- (NSURL *)getLocalReocrdPath;

/// 更新自定义UI的场景，用户调用了定制会中菜单等页面后，根据自己的业务主动触发UI刷新
/// 调用该方法会触发该UI重新调用 HWMConfCtrlItemHandler 的代理方法获取菜单，重新布局
/// @param scene 业务场景
- (void)updateCustomUIWithScene:(HWMCustomUIScene)scene;

/// 启用/关闭端到端加密
- (void)enableE2EE:(BOOL)enable;

/// 设置是否支持屏幕共享，如果不调用此方法，默认支持屏幕共享
/// @param isPermission YES表示支持共享，NO表示不支持共享
- (BOOL)setShareScreenPermission:(BOOL)isPermission;

/// 会中更多是否支持显示会控助手
/// @param support 支持显示会控助手，在初始化后入会前设置 （默认不支持）
- (HWMSDKERR)supportMeetingAssistant:(BOOL)support;

/// 设置证书校验信息
/// @param info 证书校验信息
- (HWMSDKERR)setCAVerifyInfo:(HWMUISDKCAVerifyInfoModel *)info;

/// 自定义场景文案
/// @param customSceneTextInfoList 文案模型
- (void)setCustomUITextWithCustomSceneTextInfoList:(HWMUISDKCustomSceneTextInfoListModel *)customSceneTextInfoList;

/// 设置屏幕共享中需透明的窗口
/// @param info 窗口参数，详见HWMUISDKTransparentWndInfoModel
- (HWMSDKERR)setTransparentWndWithInfo:(HWMUISDKTransparentWndInfoModel *)info;

/// 设置虚拟背景默认图片(图片格式: jpg/jpeg, 图片尺寸: 最大4096*4096, 最小160*160, 图片路径: 读权限)
/// @param defaultImagesParam 默认图片参数
- (HWMSDKERR)setVirtualBackgroundDefaultImages:(HWMVirtualBackgroundParam *)defaultImagesParam;
@end

NS_ASSUME_NONNULL_END
