﻿/**
 * @file HwmUISDKDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief [en] define file.
 *        [cn] 结构体、枚举定义文件
 */

#ifndef _HWM_UISDK_DEF_H_
#define _HWM_UISDK_DEF_H_

#include "HwmUISdkCommonDef.h"
#include "HwmBaseMacroDef.h"

BEGIN_HWM_UISDK_NAMESPACE

/**
* [en]server site type.
* [cn]服务站点类型
*/
typedef enum tagHwmSiteType
{
    HWM_SITE_TYPE_CHINA = 0,                   /**< [en]site of China
                                                    [cn]国内站点 */
    HWM_SITE_TYPE_AP,                          /**< [en]site of Asia
                                                    [cn]亚太站点 */
} HwmSiteType;

/**
* [en]Log level.
* [cn]日志级别
*/
typedef enum tagHwmLogLevel
{
    HWM_LOG_LEVEL_INFO = 0,                    /**< [en]Info level
                                                    [cn]信息（一般）级别 */
    HWM_LOG_LEVEL_WARNING,                     /**< [en]Warning level
                                                    [cn]警告级别 */
    HWM_LOG_LEVEL_ERROR,                       /**< [en]Info level
                                                    [cn]错误级别 */
} HwmLogLevel;

/**
* [en]Init info.
* [cn]初始化信息
*/
typedef struct tagHwmInitInfo
{
    HWM_CHAR exePath[HWM_MAX_FILE_PATH_LEN];                   /**< [en]The path of the exe file(only for win64)
                                                                    [cn]SDK启动路径，SDK压缩包中HwmSdk文件夹下的exe文件所在的绝对路径。
                                                                        使用前请将SDK压缩包中HwmSdk文件夹下HwmSdk.exe文件名修改为期望的名称。
                                                                        如果HwmSdk文件夹的路径为：D:\\MyApp\\SDK\\HwmSdk\\，exe文件的名称为MySdk.exe，
                                                                        则exePath=D:\\MyApp\\SDK\\HwmSdk\\MySdk.exe。
                                                                        注：需要UTF8编码。(仅对win64平台生效)
                                                                    [cs_allowNull:N][mac:disable] */
    HWM_CHAR logPath[HWM_MAX_FILE_PATH_LEN];                   /**< [en]The path of the log file
                                                                    [cn]SDK日志路径，如果不设置，则使用默认路径。
                                                                        注：需要UTF8编码。
                                                                    [cs_allowNull:N] */
    HWM_CHAR userDataPath[HWM_MAX_FILE_PATH_LEN];              /**< [en]The path of the user data file(only for win)
                                                                    [cn]SDK用户数据路径，如果不设置，则使用默认路径。
                                                                        注：需要UTF8编码。(仅对win平台生效)
                                                                    [cs_allowNull:N][mac:disable] */
    HWM_CHAR appId[HWM_MAX_APPID_LEN];                         /**< [en]The app identity
                                                                    [cn]App ID。App ID的申请，请参考“App ID鉴权介绍”章节。
                                                                    [cs_allowNull:N] */
    HwmSiteType siteType;                                      /**< [en]The site type
                                                                    [cn]站点类型。默认使用国内站点（值置0）。
                                                                    [cs_allowNull:Y] */
    HWM_UINT32 logKeepDays;                                    /**< [en]Indicates the log keeping days.
                                                                    [cn]配置项-日志保存天数，输入有效范围为3-30，默认值0。0为不按天数删除日志。
                                                                        注意：输入1和2会转换为3，大于30的值会被转换为30。
                                                                    [cs_allowNull:Y] */
    HWM_CHAR preferredCamera[HWM_MAX_PREFERRED_CAMERA_LEN];    /**< [en]preferred camera(only for win)
                                                                    [cn]优选摄像头列表，填写后，初次打开摄像头按列表中的顺序选择第一个可用的摄像头。
                                                                        可以不填，不填按照默认顺序打开可用的摄像头。(仅对win平台生效)
                                                                    [cs_allowNull:Y][mac:disable] */
    HWM_CHAR appUrl[HWM_MAX_APP_URL_LEN];                      /**< [en]The app url(only for mac)
                                                                    [cn]官网下载渠道链接(仅对mac平台生效)
                                                                    [cs_allowNull:Y][win:disable] */
    HWM_BOOL isSupportMultiAppLogin;                           /**< [en]is support multi client login.
                                                                    [cn]是否支持同终端多应用登录 */
    HWM_CHAR workSpacePluginDownloadUrl[HWM_MAX_URL_LEN];      /**< [en]WorkSpace Plugin Download Url.
                                                                    [cn]云桌面插件的下载地址配置。(仅对win平台生效)
                                                                    [cs_allowNull:Y][doc:disable][mac:disable]*/
    HwmLogLevel logLevel;                                 	   /**< [en]Indicates log level。
                                                                    [cn]日志级别
                                                                    [cs_allowNull:Y][doc:disable] */
    HWM_CHAR appVersion[HWM_MAX_APPVERSION_LEN];               /**< [en]Indicates app version。
                                                                    [cn]应用版本号
                                                                    [cs_allowNull:Y][doc:disable] */
}HwmInitInfo;

END_HWM_UISDK_NAMESPACE

#endif /* _HWM_UISDK_DEF_H_ */
