import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { VerifyMode } from '../../../Constants/enum'
import { showErrorTips } from '../../../utils'

const VerifyModeOptions = [
  {
    value: VerifyMode.VERIFY_MODE_NONE,
    label: 'Verify None',
  },
  {
    value: VerifyMode.VERIFY_MODE_SERVER,
    label: 'Verify Server',
  },
]

class SetCAVerifyInfo extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      verifyMode: VerifyMode.VERIFY_MODE_NONE,
      certPath: '',
    }
  }

  changeVerifyMode (e) {
    this.setState({
      verifyMode: Number(e.target.value),
    })
  }

  changeCertPath (e) {
    this.setState({
      certPath: e.target.value,
    })
  }

  async goToSetCAVerifyInfo () {
    const { verifyMode, certPath } = this.state
    const param = {
      verifyMode,
      certPath,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setCAVerifyInfo(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setCAVerifyInfo">
        <div className="input-box">
          <div className="input-box-title">VerifyMode:</div>
          <div className="input-box-text">
            <select value={this.state.verifyMode} onChange={this.changeVerifyMode.bind(this)}>
              {VerifyModeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">CertPath:</div>
          <div className="input-box-text">
            <input value={this.state.certPath} onChange={this.changeCertPath.bind(this)} />
          </div>
        </div>
        <button className='button' onClick={this.goToSetCAVerifyInfo.bind(this)}>Submit</button>
        <button className='button' onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetCAVerifyInfo
