import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import PropTypes from 'prop-types'
import { ConfAllowJoinUserTypeOptions } from '../../../Constants/typeOption'
import { showErrorTips } from '../../../utils'
import { DeployType } from '../../../Constants/enum'
import { connect } from 'react-redux'

class ChangeVmrInfo extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      vmrInfo: [],
      vmrIndex: 0,
    }
  }

  componentDidMount () {
    this.getVmrInfo()
  }

  refreshState () {
    const { vmrInfo } = this.state
    this.setState({
      vmrInfo: [
        ...vmrInfo,
      ],
    })
  }

  changeVmrIndex (e) {
    const vmrIndexInput = Number(e.target.value)
    this.setState({
      vmrIndex: vmrIndexInput,
    })
  }

  change (key, value) {
    const { vmrInfo, vmrIndex } = this.state
    if (vmrInfo[vmrIndex]) vmrInfo[vmrIndex][key] = value
    this.refreshState()
  }

  getValue (e) {
    return e.target.value
  }

  getCheck (e) {
    return e.target.checked
  }

  getNumberValue (e) {
    return Number(e.target.value)
  }

  async getVmrInfo () {
    const { deployType } = this.props
    if (deployType === DeployType.SINK_MODE) {
      return
    }
    const apiService = new ApiService()
    const setResult = await apiService.getVmrList()
    if (setResult.ret === 0) {
      const _vmrInfo = setResult.vmrListInfo.vmrs
      console.log('_vmrInfo:', _vmrInfo)
      this.setState({
        vmrInfo: _vmrInfo,
      })
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToChangeVmrInfo () {
    const { vmrInfo, vmrIndex } = this.state
    const { deployType } = this.props
    const param = {
      vmrId: vmrInfo[vmrIndex]?.vmrId,
      vmrName: vmrInfo[vmrIndex]?.name,
      guestPwd: vmrInfo[vmrIndex]?.guestPwd,
      hostPwd: vmrInfo[vmrIndex]?.hostPwd,
      allowGuestStartConf: vmrInfo[vmrIndex]?.allowGuestStartConf,
      isOpenWaitingRoom: vmrInfo[vmrIndex]?.isOpenWaitingRoom,
      confAllowJoinUser: vmrInfo[vmrIndex]?.confAllowJoinUser,
    }
    if (deployType === DeployType.SINK_MODE) {
      return
    }
    const apiService = new ApiService()
    const setResult = await apiService.changeVmrInfo(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    const { vmrInfo, vmrIndex } = this.state
    const {
      name: vmrName,
      guestPwd,
      hostPwd,
      allowGuestStartConf,
      isOpenWaitingRoom,
      confAllowJoinUser,
    } = vmrInfo[vmrIndex] || {}
    return (
      <div className="changeVmrInfo">
        <div className="input-box">
          <div className="input-box-title">vmrId:</div>
          <div className="input-box-text">
            <select value={vmrIndex} onChange={this.changeVmrIndex.bind(this)}>
              {
                vmrInfo.map((obj, index) => {
                  return (
                    <option value={index} key={index}>{obj.vmrConfId}</option>
                  )
                })
              }
            </select>
          </div>
        </div>

        <div className="input-box">
          <div className="input-box-title">vmrName:</div>
          <div className="input-box-text"><input value={vmrName} onChange={e => this.change('name', this.getValue(e))} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">guestPwd:</div>
          <div className="input-box-text"><input value={guestPwd} onChange={e => this.change('guestPwd', this.getValue(e))} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title">hostPwd:</div>
          <div className="input-box-text"><input value={hostPwd} onChange={e => this.change('hostPwd', this.getValue(e))} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check" style={{ width: '160px' }}>Allow Guest Start Conf:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={allowGuestStartConf} onChange={e => this.change('allowGuestStartConf', this.getCheck(e))} /></div>
        </div>
        <div className="input-box">
          <div className="input-box-title-check" style={{ width: '160px' }}>IsOpenWaitingRoom:</div>
          <div className="input-box-text-check"><input type="checkbox" checked={isOpenWaitingRoom} onChange={e => this.change('isOpenWaitingRoom', this.getCheck(e))} /></div>
        </div>
        <br />
        <div className="input-box">
          <div className="input-box-title" style={{ width: '140px' }}>ConfAllowJoinUser:</div>
          <div className="input-box-text" style={{ width: '85px' }}>
            <select value={confAllowJoinUser} onChange={e => this.change('confAllowJoinUser', this.getNumberValue(e))}>
              {ConfAllowJoinUserTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <button onClick={this.goToChangeVmrInfo.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

ChangeVmrInfo.propTypes = {
  deployType: PropTypes.oneOf([DeployType.SINK_MODE, DeployType.CLOUD_MODE]),
}

const mapStateToProps = (state) => {
  const { deployType } = state.setting.deploy
  return { deployType }
}

export default connect(mapStateToProps)(ChangeVmrInfo)
