//
//  HWMEnterpriseContact.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/11/6.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger , HWMPhoneShowType) {
    HWMPhoneShowEntire = 1, // 完全展示， 呼叫+8613234567890
    HWMPhoneShowHide   = 2, // 隐藏手机号 呼叫
    HWMPhoneShowSafe   = 3, // 脱敏展示   呼叫+86132****7890
};

NS_ASSUME_NONNULL_BEGIN

@interface HWMEnterpriseContact : NSObject
/// 部门描述,若要显示多级部门，请自行拼接  如：一级部门|二级部门|三级部门，最多展示128位
@property (nonatomic, copy) NSString *deptDesc;

/// 号码
@property (nonatomic, copy) NSString *number;

/// 手机号
@property (nonatomic, copy) NSString *phone;

/// 登录账号
@property (nonatomic, copy) NSString *account;

/// 呼叫其他号码中的号码展示形似,默认：HWMPhoneShowHide
@property (nonatomic, assign) HWMPhoneShowType phoneShowType;

@end

NS_ASSUME_NONNULL_END
