/**********************************************************************
*
* util
*
* ӿ
*
* Copyright 2020 HuaWei, Inc.
*
**********************************************************************/

#include "util.h"

#include <shlobj.h>
#include <iomanip>

#pragma pack(push, 8) /* Work around a bug in tlhelp32.h in WIN64, which generates the wrong structure if packing has been changed */
#include <ctime>
#include <tlhelp32.h>
#pragma pack(pop)

#define CHECK_LENGTH 20 

std::string Util::exeName = "HwmSdk";

Util::Util()
{
}

Util::~Util()
{
}

std::string Util::multiByte2UTF8(const std::string & str)
{
    int nwLen = ::MultiByteToWideChar(CP_ACP, 0, str.c_str(), -1, NULL, 0);

    wchar_t * pwBuf = new(std::nothrow) wchar_t[nwLen + 1];//һҪ1Ȼβ  
    if (pwBuf == nullptr)
    {
        return "";
    }
    ZeroMemory(pwBuf, nwLen * 2 + 2);

    ::MultiByteToWideChar(CP_ACP, 0, str.c_str(),str.length(), pwBuf, nwLen);

    int nLen = ::WideCharToMultiByte(CP_UTF8, 0, pwBuf, -1, NULL, NULL, NULL, NULL);

    char * pBuf = new(std::nothrow) char[nLen + 1];
    if (pBuf == nullptr)
    {
        delete[] pwBuf;
        pwBuf = nullptr;
        return "";
    }
    ZeroMemory(pBuf, nLen + 1);

    ::WideCharToMultiByte(CP_UTF8, 0, pwBuf, nwLen, pBuf, nLen, NULL, NULL);

    std::string retStr(pBuf);

    delete[]pwBuf;
    delete[]pBuf;

    pwBuf = NULL;
    pBuf = NULL;

    return retStr;
}

/* ȡappdataĿ¼ */
std::string Util::GetAppDataPath()
{
    std::string path = "D:";
    TCHAR buffer[MAX_PATH];
    BOOL result = SHGetSpecialFolderPath(NULL, buffer, CSIDL_APPDATA, false);
    if (result) {
        path = (buffer);
    }
    return path;
}

std::string Util::DesensitiveStr(const std::string& orgStr)
{
    int strLen = orgStr.length();
    if(strLen == 0)
    {
        return "";
    }
    else if(strLen == 1)
    {
        return "*";
    }
    else if(strLen == 2)
    {
        return "**";
    }
    else if(strLen == 3)
    {
        return "***";
    }

    std::string ouputString = orgStr;
    if(4 == strLen || 5 == strLen)
    {
        /* 45λεڶλ*/
        ouputString[strLen - 2] = '*';
    }
    else if(6 == strLen || 7 == strLen)
    {
        /* 6-7λλε345λ*/
        ouputString[strLen - 3] = '*';
        ouputString[strLen - 4] = '*';
        ouputString[strLen - 5] = '*';
    }
    else if(strLen >= 8 && strLen <= 10)
    {
        /* 8-10λλε3456λ*/
        ouputString[strLen - 3] = '*';
        ouputString[strLen - 4] = '*';
        ouputString[strLen - 5] = '*';
        ouputString[strLen - 6] = '*';
    }
    else if(strLen >= 11)
    {
        /* 11λϱλǰλλ*/
        int strIndex = 0;

        for(strIndex = 3; strIndex < strLen - 2; strIndex++)
        {
            ouputString[strIndex] = '*';
        }
    }
    else
    {
        //for pclint
    }

    return ouputString;
}

std::string Util::SafePrintNameOrNumber(const std::string& srcString, bool isNumber)
{
    std::wstring wstrSrc = UTF8ToWideChar(srcString);
    int wSrcLen = wstrSrc.length();
    if(wSrcLen == 0)
    {
        return srcString;
    }

    int frontCount = isNumber ? 3 : 1;
    int backCount = 2;
    if(wSrcLen == 1)
    {
        frontCount = 0;
        backCount = 0;
    }

    if(wSrcLen == 2 || wSrcLen == 3)
    {
        frontCount = 1;
        backCount = 0;
    }

    std::wstring wstrDst = wstrSrc.substr(0,frontCount);
    wstrDst += L"***";
    wstrDst += wstrSrc.substr(wSrcLen - backCount, backCount);

    return UnicodeToUTF8(wstrDst);
}

std::string Util::SafePrintIp(const std::string& inputString)
{
    if (inputString.length() == 0) {
        return "";
    }
	std::string res;
    std::string ip = inputString;
	if(IsIPv4(ip.c_str()))
	{
		std::vector<std::string> ipdot = Split(ip, ".");
		res = ipdot[0] + "." + DesensitiveStr(ipdot[1]) + "." + DesensitiveStr(ipdot[2]) + "." + ipdot[3];
	}
	else
	{
		res = DesensitiveStr(ip);
	}

    return res;
}

std::string Util::SafePrintPath(const std::string& inputString)
{
    if (inputString.length() == 0) {
        return "";
    }
	std::string res;
    std::string path = inputString;
	int start_pos = path.find("Users");
    int end_pos = path.find("AppData");
    if(start_pos == -1 || end_pos == -1)
    {
        return path;
    }

    int nameLen = end_pos - start_pos - 6 -1;
    if (nameLen <= 0)
    {
        return path;
    }
    std::string userName = path.substr(start_pos+6, nameLen);
    res = path.substr(0,start_pos+6) + SafePrintNameOrNumber(userName) + path.substr(end_pos-1);

    return res;
}

std::string Util::SafePrintAccount(const std::string& inputString)
{
    if (inputString.length() == 0) {
        return "";
    }
    std::string ouputString = inputString;
	std::string::size_type atpos = inputString.find("@");
	if(atpos != std::string::npos
		&& atpos != 0
		&& atpos != inputString.length() - 1)
	{
		ouputString[atpos - 1] = '*';
		ouputString[  atpos  ] = '*';
		ouputString[atpos + 1] = '*';
	}
	else
	{
        //мֶμ
		int k = inputString.length() / 2;
		if(inputString.length() > 11)
		{
			ouputString[k - 2] = '*';
			ouputString[k - 1] = '*';
			ouputString[  k  ] = '*';
			ouputString[k + 1] = '*';
			ouputString[k + 2] = '*';
		}
        else if (inputString.length() < 3){
            ouputString[k] = '*';
        }
		else
		{
			ouputString[k - 1] = '*';
			ouputString[  k  ] = '*';
			ouputString[k + 1] = '*';
		}
    }

    return ouputString;
}

std::vector<std::string> Util::Split(const std::string& str, const std::string& delim) 
{
   std::vector<std::string> vec;
   std::string::size_type pos = 0;
   std::string::size_type len = str.length();
   std::string::size_type delim_len = delim.length();

   while (pos < len)
   {
       int find_pos = str.find(delim, pos);

       if (find_pos < 0)
       {
           vec.push_back(str.substr(pos, len - pos));
           break;
       }

       vec.push_back(str.substr(pos, find_pos - pos));
       pos = find_pos + delim_len;
    }

	return vec;  
}

bool Util::IsIPv4(std::string ip)
{
    if(ip.length() > 15)
    {
        return false;
    }

    int a=-1,b=-1,c=-1,d=-1;
    char s[16]={0};
    UINT32 secRet = 0;
    secRet = sscanf_s(ip.c_str(), "%d.%d.%d.%d%s", &a, &b, &c, &d, s, sizeof(s));
    if (secRet != 0)
    {
        // LOG_INFO("secure function return error.");
    }

    if(a > 255 || a < 0 || b > 255 || b < 0 || c > 255 || c < 0 || d > 255 || d < 0 || s[0] != 0)
    {
        return false;
    }

    return true;
}

std::wstring Util::UTF8ToWideChar(const std::string str )
{
    LPWSTR pWstr;
    //ʱĴС
    int i = MultiByteToWideChar(CP_UTF8, 0, str.c_str(), -1, NULL, 0);
    if (i < 0)
    {
        i = 0;
    }
    pWstr = new(std::nothrow) WCHAR[i + 1]();
    if (pWstr == nullptr)
    {
        return std::wstring(L"");
    }
    MultiByteToWideChar(CP_UTF8, 0, str.c_str(), -1, pWstr, i);
    //Ͻ
    pWstr[i] = '\0';
    std::wstring result(pWstr);
    delete [] pWstr;
    pWstr = nullptr;
    return result;
}

std::string Util::UnicodeToUTF8(const std::wstring& wstr)
{
    std::string strRet("");
    char* result = nullptr;
    int textlen;
    textlen = WideCharToMultiByte( CP_UTF8, 0, wstr.c_str(), -1, NULL, 0, NULL, NULL );
    if (textlen <= 0) {
        return NULL;
    }

    result = new(std::nothrow) char[textlen + 1]();
    if (NULL == result)
    {
        return NULL;
    }

    WideCharToMultiByte( CP_UTF8, 0, wstr.c_str(), -1, result, textlen, NULL, NULL );
    strRet = result;
    delete[] result;
    result = nullptr;
    return strRet;
} 

int Util::SeucreCopyStr(char* dst, unsigned int dstLen, const char* src)
{

    if(dstLen > ::strlen(src))
    {
        return strcpy_s(dst,dstLen,src);
    }
    else
    {
        return strncpy_s(dst, dstLen, src, dstLen - 1);
    }

}

std::string Util::AnsiToUTF8(const std::string& str)
{
    if (str.empty())
    {
        return "";
    }
    int nwLen = ::MultiByteToWideChar(CP_ACP, 0, str.c_str(), -1, NULL, 0);
    if (nwLen <= 0)
    {
        return "";
    }

    wchar_t * pwBuf = new(std::nothrow) wchar_t[nwLen + 1]();//һҪ1Ȼβ  
    if (pwBuf == nullptr)
    {
        return "";
    }

    ::MultiByteToWideChar(CP_ACP, 0, str.c_str(), str.length(), pwBuf, nwLen);

    int nLen = ::WideCharToMultiByte(CP_UTF8, 0, pwBuf, -1, NULL, NULL, NULL, NULL);
    if (nLen < 0)
    {
        delete[] pwBuf;
        pwBuf = nullptr;
        return "";
    }
    char * pBuf = new(std::nothrow) char[nLen + 1]();
    if (pBuf == nullptr)
    {
        delete pwBuf;
        pwBuf = nullptr;
        return "";
    }

    if (nwLen <= nLen)
    {
        ::WideCharToMultiByte(CP_UTF8, 0, pwBuf, nwLen, pBuf, nLen, NULL, NULL);
    }
    else
    {
        delete[] pwBuf;
        delete[] pBuf;
        pwBuf = nullptr;
        pBuf = nullptr;
        return "";
    }

    std::string retStr(pBuf);
    delete[] pwBuf;
    delete[] pBuf;

    pwBuf = nullptr;
    pBuf = nullptr;

    return retStr;
}

std::string Util::WChar2Ansi(LPCWSTR pwszSrc)
{
    int nLen = WideCharToMultiByte(CP_ACP, 0, pwszSrc, -1, NULL, 0, NULL, NULL);

    if (nLen <= 0) return std::string("");

    char* pszDst = new(std::nothrow) char[nLen]();
    if (pszDst == nullptr)
    {
        return std::string("");
    }

    WideCharToMultiByte(CP_ACP, 0, pwszSrc, -1, pszDst, nLen, NULL, NULL);
    pszDst[nLen - 1] = 0;

    std::string strTemp(pszDst);
    delete[] pszDst;
    pszDst = nullptr;

    return strTemp;
}

std::string Util::Json2String(const Json::Value& json)
{
    Json::StreamWriterBuilder writerBuilder;
    writerBuilder["indentation"] = "";
    return Json::writeString(writerBuilder, json).c_str();
}

napi_value Util::CharToUint8Array(Napi::Env env, const char* data, size_t length)
{
    napi_value result;
    
    if (length < 0)
    {
        return result;
    }

    void* buffer = malloc(length);
    if (buffer == nullptr)
    {
        return result;
    }
    memcpy_s(buffer, length, data, length);
    
    // ⲿ
    napi_create_external_arraybuffer(env, buffer, length, NULL, NULL, &result);
    
    // ͼ
    napi_create_typedarray(env, napi_uint8_array, length, result, NULL, &result);

    return result;
}