import React from 'react'
import './index.css'
import ApiService from '../../../../AppService/ApiService'
import { Language } from '../../../../Constants/enum'
import { showErrorTips } from '../../../../utils'

const LanguageTypeOptions = [
  {
    value: Language.HWM_LANGUAGE_ZH_CN,
    label: 'Chinese',
  },
  {
    value: Language.HWM_LANGUAGE_EN_GB,
    label: 'English',
  },
  {
    value: Language.HWM_LANGUAGE_CUSTOMIZED,
    label: 'Customized',
  },
]

class SetLanguage extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      type: Language.HWM_LANGUAGE_ZH_CN,
      languageCode: '',
    }
  }

  changeType (e) {
    this.setState({
      type: Number(e.target.value),
    })
  }

  changeLanguageCode (e) {
    this.setState({
      languageCode: e.target.value,
    })
  }

  async goToSetLanguage () {
    const { type, languageCode } = this.state
    const param = {
      type,
      languageCode,
    }
    const apiService = new ApiService()
    const setResult = await apiService.setLanguage(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="setLanguage">
        <div className="input-box">
          <div className="input-box-title">Type:</div>
          <div className="input-box-text">
            <select value={this.state.type} onChange={this.changeType.bind(this)}>
              {LanguageTypeOptions.map(item => {
                return <option value={item.value} key={item.value}>{item.label}</option>
              })}
            </select>
          </div>
        </div>
        <div>
          <div className='input-box-title'>Customized Language Code: </div>
          <div className="input-box-text"><input value={this.state.languageCode} onChange={this.changeLanguageCode.bind(this)} /></div>
        </div>
        <button onClick={this.goToSetLanguage.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default SetLanguage
