import React from 'react'
import './index.css'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'
import { isMac } from 'hwmsdk-electron-demo/src/common/platform'

class ConfigPage extends React.Component {
  constructor (props) {
    super(props)
    this.state = {

    }
  }

  goToConfig () {
    this.props.history.push('/configPage/config')
  }

  goToEnableCapability () {
    this.props.history.push('/configPage/enableCapability')
  }

  async goToGetConfPstnAccessNumber () {
    const apiService = new ApiService()
    const setResult = await apiService.getConfPstnAccessNumber()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToGetRenderWindowInfoList () {
    const apiService = new ApiService()
    const setResult = await apiService.getRenderWindowInfoList()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goToRenameSelf () {
    this.props.history.push('/configPage/renameSelf')
  }

  goToSetAvatar () {
    this.props.history.push('./configPage/setAvatar')
  }

  goToSetDeviceConfigForConfIncoming () {
    this.props.history.push('./configPage/setDeviceConfigForConfIncoming')
  }

  goToSetLanguage () {
    this.props.history.push('/configPage/setLanguage')
  }

  goToSetUserSavePath () {
    this.props.history.push('./configPage/setUserSavePath')
  }

  goToGetUserSavePath () {
    this.props.history.push('./configPage/getUserSavePath')
  }

  goToSetWaterMark () {
    this.props.history.push('./configPage/setWaterMark')
  }

  async goToShowMeetingWindow () {
    const apiService = new ApiService()
    const setResult = await apiService.showMeetingWindow()
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async goToAgreeVoiceprintStatement () {
    const apiService = new ApiService()
    const setResult = await apiService.agreeVoiceprintStatement(true)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goToSetAnswerType () {
    this.props.history.push('./configPage/setAnswerType')
  }

  goToSetMeetingWindowIcon () {
    this.props.history.push('./configPage/setMeetingWindowIcon')
  }

  goToDisableVoicePrompts () {
    this.props.history.push('./configPage/disableVoicePrompts')
  }

  goToSharePermission () {
    this.props.history.push('./configPage/sharePermission')
  }

  goToSetTransparentWnd = () => {
    this.props.history.push('/configPage/SetTransparentWnd')
  }

  goToSetAvatarStyle = () => {
    this.props.history.push('/configPage/setAvatarStyle')
  }

  goToSetVirtualBackgroundDefaultImages = () => {
    this.props.history.push('/configPage/setVirtualBackgroundDefaultImages')
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
            <div className="configPage">
                <button onClick={this.goToConfig.bind(this)}>Config</button>
                <button onClick={this.goToEnableCapability.bind(this)}>Enable Capability</button>
                <button onClick={this.goToRenameSelf.bind(this)}>Rename Self</button>
                <button onClick={this.goToSetLanguage.bind(this)}>Set Language</button>
                <button onClick={this.goToGetConfPstnAccessNumber.bind(this)}>Get Pstn Number</button>
                <button onClick={this.goToGetRenderWindowInfoList.bind(this)}>Get Render WindowInfo List</button>
                <button onClick={this.goToSetAvatar.bind(this)}>Set Avatar</button>
                <button onClick={this.goToSetDeviceConfigForConfIncoming.bind(this)}>Set DeivceInfo for ConfIncoming</button>
                <button onClick={this.goToSetUserSavePath.bind(this)}>Set User Save path</button>
                <button onClick={this.goToGetUserSavePath.bind(this)}>Get User Save path</button>
                <button onClick={this.goToSetWaterMark.bind(this)}>Set Water Mark</button>
                <button onClick={this.goToShowMeetingWindow.bind(this)}>Show Meeting Window</button>
                <button onClick={this.goToSetAnswerType.bind(this)}>Set AnswerType</button>
                <button onClick={this.goToSetMeetingWindowIcon.bind(this)}>Set Meeting Window Icon</button>
                <button onClick={this.goToDisableVoicePrompts.bind(this)}>Disable Voice Prompts</button>
                <button onClick={this.goToSharePermission.bind(this)}>Share Permission</button>
                <button onClick={this.goToSetTransparentWnd.bind(this)}>SetTransparentWnd</button>
                <button onClick={this.goToSetAvatarStyle.bind(this)}>Set Avatar Style</button>
                {!isMac() && <button onClick={this.goToAgreeVoiceprintStatement.bind(this)}>Agree Voiceprint Statement</button>}
                <button onClick={this.goToSetVirtualBackgroundDefaultImages.bind(this)}>Set Default VirtualBackground Images</button>
                <button style={{ width: '110px' }} onClick={this.goBack.bind(this)}>Back</button>
            </div>
    )
  }
}

export default ConfigPage
