import React from 'react'
import { connect } from 'react-redux'
import PropTypes from 'prop-types'
import { SDKERR } from 'hwmsdk-electron/ts/Api/enum'

import './index.css'
import ApiService from 'hwmsdk-electron-demo/src/AppService/ApiService'
import { showErrorTips } from 'hwmsdk-electron-demo/src/utils'
import { updateServer } from 'hwmsdk-electron-demo/redux/settingSlice'

class SetServerAddress extends React.Component {
  changeServerAddr (e) {
    updateServer({
      serverAddr: e.target.value,
    })
  }

  changeServerPort (e) {
    updateServer({
      serverPort: Number(e.target.value),
    })
  }

  goBack () {
    this.props.history.goBack()
  }

  async submit () {
    const { serverAddr, serverPort } = this.props
    const param = { serverAddr, serverPort }
    const apiService = new ApiService()
    const setResult = await apiService.setServerAddress(param)
    if (setResult.ret === SDKERR.SDKERR_SUCCESS) {
      this.goBack()
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  render () {
    const { serverAddr, serverPort } = this.props
    return (
      <div className='setServerAddress'>
        <div className='input-box'>
          <div className='input-box-title'>ServerAddr:</div>
          <div className='input-box-text'>
            <input value={serverAddr} onChange={this.changeServerAddr.bind(this)} />
          </div>
        </div>
        <div className='input-box'>
          <div className='input-box-title'>ServerPort:</div>
          <div className='input-box-text'>
            <input value={serverPort} onChange={this.changeServerPort.bind(this)} />
          </div>
        </div>
        <button onClick={this.submit.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

SetServerAddress.propTypes = {
  serverAddr: PropTypes.string,
  serverPort: PropTypes.number,
}

const mapStateToProps = (state) => {
  const { serverAddr, serverPort } = state.setting.server
  return { serverAddr, serverPort }
}
export default connect(mapStateToProps)(SetServerAddress)
