import React from 'react'
import moment from 'moment-timezone'

import './index.css'
import ApiService from '../../../AppService/ApiService'
import { MediaType, ConfAllowJoinUserType, Timezone, CycleType, VmrConfIdType, AutoMuteType, DeployType } from '../../../Constants/enum'
import PropTypes from 'prop-types'
import { MediaTypeOptions, ConfAllowJoinUserTypeOptions, VmrConfIdTypeOptions, TerminalAutoMuteTypeOptions } from '../../../Constants/typeOption'
import { getCycleTypeOptions, getIntervalOptions } from '../BookConf/helper'
import EditCycleSubConf from './editCycleSubConf'
import { showErrorTips } from '../../../utils'
import { connect } from 'react-redux'

const FORMAT_DATE_MINUTE = 'YYYY-MM-DD HH:mm'
const FORMAT_DATE = 'YYYY-MM-DD'
class ConfInfo extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      confId: '',
      subject: '',
      startTimeStampStr: '',
      duration: '60',
      timezone: Timezone.HWM_TIMEZONE_BEIJING,
      mediaType: MediaType.HWM_MEDIA_TYPE_VIDEO,
      needPassword: false,
      vmrFlag: false,
      vmrId: '',
      vmrName: '',
      hostPwd: '',
      guestPwd: '',
      isAutoRecord: false,
      allowRecord: false,
      allowLive: false,
      isSendSms: false,
      isSendEmail: false,
      isSendCalendar: false,
      isSendSmsDefault: false,
      isSendEmailDefault: false,
      isSendCalendarDefault: false,
      isOpenWaitingRoom: false,
      confAllowJoinUser: ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE,
      attendees: '',
      attendeesExample: '[{"nickName":"店小二","aliasCN":"汤姆","aliasEN":"tom","number":"15211111111","thirdUserId":"","extendedField":""}]',
      vmrConfId: '',
      cycleParam: { // 周期会议参数
        startTimeStampStr: '',
        endTimeStampStr: '',
        cycleType: CycleType.CYCLE_TYPE_WEEK, // 周期类型， 默认按周
        interval: 1, // 周期频率， 默认每1周
        listPoints: [], // 会议召开点，默认开始时间的星期X
        preRemindDays: 1, // 提前通知天数， 默认提前1天
      },
      listPointsExample: '0, 1, 2',
      allowGuestStartConf: true,
      allowGuestStartConfTime: 0,
      isEditSubConf: false,
      curSubConf: null,
      conferenceType: 0,
      vmrConfIdType: VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED,
      customInfo: '',
      concurrentParticipants: 0, // 会议方数，会议最大与会人数限制. 0: 无限制, 大于0: 会议最大与会人数
      defaultSummaryState: false,
      autoPublishSummary: true,
      autoMuteMode: AutoMuteType.AUTO_MUTE_TYPE_MUTE,
      hardTerminalAutoMuteMode: AutoMuteType.AUTO_MUTE_TYPE_UNMUTE,
      supportWatermark: false,
      forbiddenScreenShots: false,
      attendeesExcludeSelf: false,
    }
  }

  componentDidMount () {
    const _confId = this.props.location.query.confId
    this.getConfInfoById(_confId)
  }

  changeSubject (e) {
    this.setState({
      subject: e.target.value,
    })
  }

  changeStartTime (e) {
    const { cycleParam } = this.state
    this.setState({
      startTimeStampStr: e.target.value,
      cycleParam: { ...cycleParam, startTimeStampStr: e.target.value },
    })
  }

  changeDuration (e) {
    this.setState({
      duration: Number(e.target.value),
    })
  }

  changeMediaType (e) {
    this.setState({
      mediaType: Number(e.target.value),
    })
  }

  changeTimezone (e) {
    this.setState({
      timezone: Number(e.target.value),
    })
  }

  changeConfAllowJoinUser (e) {
    this.setState({
      confAllowJoinUser: Number(e.target.value),
    })
  }

  changeIsSendSms (e) {
    this.setState({
      isSendSms: e.target.checked,
    })
  }

  changeIsSendEmail (e) {
    this.setState({
      isSendEmail: e.target.checked,
    })
  }

  changeIsSendCalendar (e) {
    this.setState({
      isSendCalendar: e.target.checked,
    })
  }

  changeIsOpenWaitingRoom (e) {
    this.setState({
      isOpenWaitingRoom: e.target.checked,
    })
  }

  changeConcurrentParticipants (e) {
    this.setState({
      concurrentParticipants: Number(e.target.value),
    })
  }

  changeAllowGuestStartConf (e) {
    this.setState({
      allowGuestStartConf: e.target.checked,
    })
  }

  changeAllowGuestStartConfTime (e) {
    this.setState({
      allowGuestStartConfTime: Number(e.target.value),
    })
  }

  changeEndDateStr (e) {
    const { cycleParam } = this.state
    this.setState({
      cycleParam: { ...cycleParam, endTimeStampStr: e.target.value },
    })
  }

  editCycleSubConf (subConf) {
    console.log('subConfdd')
    console.log(subConf)
    this.setState({
      isEditSubConf: true,
      curSubConf: subConf,
    })
  }

  editCycleSubConfSuccess () {
    console.log('edit suceess')
    this.setState({
      isEditSubConf: false,
      curSubConf: null,
    })
    const { confId } = this.state
    this.getConfInfoById(confId)
  }

  changeAttendees (e) {
    this.setState({
      attendees: e.target.value,
    })
  }

  changeCustomInfo (e) {
    this.setState({
      customInfo: e.target.value,
    })
  }

  changeIsAutoRecord (e) {
    this.setState({
      isAutoRecord: e.target.checked,
    })
  }

  changeDefaultSummaryState (e) {
    this.setState({
      defaultSummaryState: e.target.checked,
    })
  }

  changeAutoPublishSummary (e) {
    this.setState({
      autoPublishSummary: e.target.checked,
    })
  }

  changeAllowRecord (e) {
    this.setState({
      allowRecord: e.target.checked,
    })
  }

  changeSoftTerminalAutoMute = (e) => {
    this.setState({ autoMuteMode: Number(e.target.value) })
  }

  changeHardTerminalAutoMuteMode = (e) => {
    this.setState({ hardTerminalAutoMuteMode: Number(e.target.value) })
  }

  changeSupportWatermark = (e) => {
    const val = e.target.checked
    this.setState({
      supportWatermark: val,
    })
  }

  changeForbiddenScreenShots = (e) => {
    const val = e.target.checked
    this.setState({
      forbiddenScreenShots: val,
    })
  }

  changeAttendeesExcludeSelf = (e) => {
    const val = e.target.checked
    this.setState({
      attendeesExcludeSelf: val,
    })
  }

  async getConfInfoById (confId) {
    const param = {
      confId,
    }
    const apiService = new ApiService()
    const setResult = await apiService.getConfDetail(param)
    if (setResult.ret === 0) {
      const _data = setResult.confDetail
      console.log('confDetail:', _data)
      const _attendees = _data.attendees ? JSON.stringify(_data.attendees) : ''
      const _duration = (Number(_data.confListInfo.endTimeStamp) - Number(_data.confListInfo.startTimeStamp)) / 60
      this.setState({
        confId: _data.confListInfo.confId,
        subject: _data.confListInfo.subject,
        startTimeStampStr: moment.unix(_data.confListInfo.startTimeStamp).format(FORMAT_DATE_MINUTE),
        duration: _duration,
        timezone: _data.confListInfo.timezone,
        mediaType: _data.confListInfo.mediaType,
        needPassword: _data.needPassword,
        vmrFlag: _data.vmrId.length !== 0,
        vmrId: _data.vmrId,
        isAutoRecord: _data.isAutoRecord,
        allowRecord: _data.allowRecord,
        allowLive: _data.allowLive,
        isSendSms: _data.isSendSms,
        isSendEmail: _data.isSendEmail,
        isSendCalendar: _data.isSendCalendar,
        isSendSmsDefault: _data.isSendSms,
        isSendEmailDefault: _data.isSendEmail,
        isSendCalendarDefault: _data.isSendCalendar,
        confAllowJoinUser: _data.confAllowJoinUser,
        attendees: _attendees,
        isOpenWaitingRoom: _data.isOpenWaitingRoom,
        vmrConfId: _data.confListInfo.vmrConfId,
        conferenceType: _data.confListInfo.conferenceType,
        allowGuestStartConf: _data.allowGuestStartConf,
        allowGuestStartConfTime: _data.allowGuestStartConfTime,
        vmrConfIdType: _data.vmrConfIdType,
        customInfo: _data.confListInfo.customInfo,
        concurrentParticipants: _data.concurrentParticipants,
        defaultSummaryState: _data.defaultSummaryState,
        autoPublishSummary: _data.autoPublishSummary,
        autoMuteMode: _data.autoMuteMode,
        hardTerminalAutoMuteMode: _data.hardTerminalAutoMuteMode,
        supportWatermark: _data.supportWatermark,
        forbiddenScreenShots: _data.forbiddenScreenShots,
      })
      if (_data.confListInfo.conferenceType === 1) { // 周期会议
        this.setState({
          cycleParam: {
            ..._data.confListInfo.cycleParam,
            startTimeStampStr: moment.unix(_data.confListInfo.cycleParam.startTimeStamp).format(FORMAT_DATE_MINUTE),
            endTimeStampStr: moment.unix(_data.confListInfo.cycleParam.endTimeStamp).format(FORMAT_DATE),
          },
          subConfParam: _data.confListInfo.subConfParam,
        })
      }
    } else {
      showErrorTips(setResult.ret, setResult.reason)
    }

    const { vmrFlag, vmrId } = this.state
    const { deployType } = this.props

    // 获取vmr信息
    if (vmrFlag && deployType !== DeployType.CLOUD_MODE) {
      const apiService = await new ApiService()
      const setResult = await apiService.getVmrList()
      if (setResult.ret === 0) {
        const _vmrInfo = setResult.vmrListInfo.vmrs
        for (const vmr of _vmrInfo) {
          if (vmr.vmrId === vmrId) {
            console.log('vmr:', vmr)
            this.setState({
              vmrName: vmr.name,
              hostPwd: vmr.hostPwd,
              guestPwd: vmr.guestPwd,
            })
            break
          }
        }
      } else {
        showErrorTips(setResult.ret, setResult.reason)
      }
    }
  }

  async dealAllowGuestStartConf () {
    const { vmrFlag, vmrConfIdType, vmrId, guestPwd, allowGuestStartConf, vmrName, hostPwd } = this.state
    if (vmrFlag && vmrConfIdType === VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED) {
      const param = {
        vmrId,
        guestPwd,
        allowGuestStartConf,
        vmrName,
        hostPwd,
      }
      const apiService = new ApiService()
      await apiService.changeVmrInfo(param)
    }
  }

  async editConf () {
    // 先处理来宾提前入会字段
    await this.dealAllowGuestStartConf()

    const {
      confId, subject, startTimeStampStr, duration, mediaType, needPassword, timezone, vmrId, confAllowJoinUser, isSendSms, isSendEmail,
      isSendCalendar, vmrConfIdType, attendees, isAutoRecord, allowRecord, allowLive, isOpenWaitingRoom, conferenceType,
      cycleParam, allowGuestStartConf, allowGuestStartConfTime, customInfo, concurrentParticipants, defaultSummaryState, autoPublishSummary, autoMuteMode, hardTerminalAutoMuteMode,
      supportWatermark, forbiddenScreenShots, attendeesExcludeSelf,
    } = this.state
    const _attendees = attendees ? JSON.parse(attendees) : ''
    const param = {
      confId,
      startTimeStamp: moment(startTimeStampStr).unix(),
      duration: Number(duration),
      isSendCalendar,
      confCommonParam: {
        subject,
        mediaType, // 0:音频 1 视频
        needPassword,
        timezone,
        vmrId,
        vmrConfIdType,
        confAllowJoinUser,
        isSendSms,
        isSendEmail,
        attendees: _attendees,
        isAutoRecord,
        allowRecord,
        allowLive,
        isOpenWaitingRoom,
        allowGuestStartConf,
        allowGuestStartConfTime,
        forbiddenScreenShots,
        customInfo,
        concurrentParticipants,
        defaultSummaryState: defaultSummaryState ? 1 : 0,
        autoPublishSummary,
        autoMuteMode,
        hardTerminalAutoMuteMode,
        supportWatermark,
        attendeesExcludeSelf,
      },
    }
    const apiService = new ApiService()
    let setResult
    if (conferenceType === 1) {
      const {
        startTimeStampStr,
        endTimeStampStr,
        cycleType,
        interval,
        listPoints,
        preRemindDays,
      } = cycleParam
      setResult = await apiService.editCycleConf({
        editConfParam: param,
        cycleParam: {
          startTimeStamp: moment(startTimeStampStr).unix(),
          endTimeStamp: moment(endTimeStampStr).unix(),
          cycleType,
          interval,
          listPoints,
          preRemindDays,
        },
      })
      this.props.history.push('/main')
    } else {
      setResult = await apiService.editConf(param)
    }
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  async cancelConfById () {
    const { confId, conferenceType } = this.state
    const param = {
      confId,
    }
    console.log(param)
    const apiService = new ApiService()
    let setResult
    if (conferenceType === 1) {
      param.endOnlineConf = true
      setResult = await apiService.cancelCycleConf(param)
    } else {
      // 取消普通会议
      setResult = await apiService.cancelConf(param)
    }
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
    this.props.history.push('/main')
  }

  async cancelCycleSubConf (subConf) {
    const { confId, subConfParam } = this.state
    const { subConfID } = subConf
    const param = {
      confId,
      subConfID,
      endOnlineConf: true,
    }
    const apiService = new ApiService()
    const setResult = await apiService.cancelSubCycleConf(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
    const index = subConfParam.findIndex((item) => item.subConfID === subConfID)
    subConfParam.splice(index, 1)
    this.setState({
      subConfParam,
    })
    if (subConfParam.length <= 0) {
      this.goBack()
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    const {
      confId,
      startTimeStampStr,
      isSendSms,
      isSendEmail,
      isSendCalendar,
      isSendSmsDefault,
      isSendEmailDefault,
      isSendCalendarDefault,
      conferenceType,
      cycleParam,
      cycleParam: {
        endTimeStampStr,
        cycleType,
        interval,
        listPoints,
        preRemindDays,
      },
      listPointsExample,
      subConfParam,
      isEditSubConf,
      curSubConf,
      vmrFlag,
      vmrId,
      guestPwd,
      vmrName,
      hostPwd,
      vmrConfIdType,
      autoMuteMode,
      hardTerminalAutoMuteMode,
    } = this.state
    const allowGuestStartConfTimeDisable = vmrFlag && (vmrConfIdType === VmrConfIdType.HWM_VMR_CONF_ID_TYPE_FIXED)
    const showCycleConf = conferenceType === 1
    const intervalOptions = getIntervalOptions(cycleType) || []
    if (!intervalOptions.find(item => item.value === interval)) {
      this.setState({ cycleParam: { ...cycleParam, interval: 1 } })
    }
    return (
            <div className="confInfo">
                <div className="input-box">
                    <div className="input-box-title">Conf Subject:</div>
                    <div className="input-box-text"><input value={this.state.subject} onChange={this.changeSubject.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title">Start Time:</div>
                    <div className="input-box-text"><input value={startTimeStampStr} onChange={this.changeStartTime.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title">Duration:</div>
                    <div className="input-box-text"><input value={this.state.duration} onChange={this.changeDuration.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title">Media Type:</div>
                    <div className="input-box-text">
                        <select value={this.state.mediaType} onChange={this.changeMediaType.bind(this)}>
                            {MediaTypeOptions.map(item => {
                              return <option value={item.value} key={item.value}>{item.label}</option>
                            })}
                        </select>
                    </div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">isAutoRecord:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.isAutoRecord} onChange={this.changeIsAutoRecord.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">allowRecord:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.allowRecord} onChange={this.changeAllowRecord.bind(this)} /></div>
                </div>
                <div className="input-box">
                  <div className="input-box-title-check">DefaultSummaryState:</div>
                  <div className="input-box-text-check"><input type="checkbox" checked={this.state.defaultSummaryState} onChange={this.changeDefaultSummaryState.bind(this)} /></div>
                </div>
                <div className="input-box">
                  <div className="input-box-title-check">AutoPublishSummary:</div>
                  <div className="input-box-text-check"><input type="checkbox" checked={this.state.autoPublishSummary} onChange={this.changeAutoPublishSummary.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">Allow Guest Start Conf:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.allowGuestStartConf} onChange={this.changeAllowGuestStartConf.bind(this)}/></div>
                </div>
                <div className="input-box" style={{ display: 'flex', margin: '10px 0px' }}>
                    <div className="input-box-title">Advance Conf Time:</div>
                    <div className="input-box-text">
                        <select value={this.state.allowGuestStartConfTime} disabled={allowGuestStartConfTimeDisable || !this.state.allowGuestStartConf} onChange={this.changeAllowGuestStartConfTime.bind(this)}>
                            <option value ="5">5 min</option>
                            <option value ="10">10 min</option>
                            <option value ="15">15 min</option>
                            <option value ="30">30 min</option>
                            <option value ="0">anytime</option>
                        </select>
                    </div>
                </div>
                <div className="input-box">
                    <div className="input-box-title">Timezone:</div>
                    <div className="input-box-text"><input value={this.state.timezone} onChange={this.changeTimezone.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">Vmr Flag:</div>
                    <div className="input-box-text-check"><input type="checkbox" disabled checked={this.state.vmrFlag} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title">Vmr Id:</div>
                    <div className="input-box-text"><input value={this.state.vmrId} disabled /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title" style={{ width: '140px' }}>VmrConfIdType:</div>
                    <div className="input-box-text" style={{ width: '85px' }}>
                        <select value={this.state.vmrConfIdType} disabled>
                            {VmrConfIdTypeOptions.map(item => {
                              return <option value={item.value} key={item.value}>{item.label}</option>
                            })}
                        </select>
                    </div>
                </div>
                <div className="input-box">
                    <div className="input-box-title" style={{ width: '140px' }}>ConfAllowJoinUser:</div>
                    <div className="input-box-text" style={{ width: '85px' }}>
                        <select value={this.state.confAllowJoinUser} onChange={this.changeConfAllowJoinUser.bind(this)}>
                            {ConfAllowJoinUserTypeOptions.map(item => {
                              return <option value={item.value} key={item.value}>{item.label}</option>
                            })}
                        </select>
                    </div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">IsSendSms:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={isSendSms} disabled={isSendSmsDefault} onChange={this.changeIsSendSms.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">IsSendEmail:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={isSendEmail} disabled={isSendEmailDefault} onChange={this.changeIsSendEmail.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">IsSendCalendar:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={isSendCalendar} disabled={isSendCalendarDefault} onChange={this.changeIsSendCalendar.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">IsOpenWaitingRoom:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.isOpenWaitingRoom} onChange={this.changeIsOpenWaitingRoom.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">ForbiddenScreenShots:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.forbiddenScreenShots} onChange={this.changeForbiddenScreenShots.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">SupportWatermark:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.supportWatermark} onChange={this.changeSupportWatermark.bind(this)} /></div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">AttendeesExcludeSelf:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={this.state.attendeesExcludeSelf} onChange={this.changeAttendeesExcludeSelf.bind(this)} /></div>
                </div>
                <div className="input-box">
                  <div className="input-box-title-check">SoftTerminalAutoMute:</div>
                  <div className="input-box-text-check">
                    <select value={autoMuteMode} onChange={this.changeSoftTerminalAutoMute}>
                      {TerminalAutoMuteTypeOptions.map(item => {
                        return <option value={item.value} key={item.value}>{item.label}</option>
                      })}
                    </select>
                  </div>
                </div>
                <div className="input-box">
                  <div className="input-box-title-check">HardTerminalAutoMute:</div>
                  <div className="input-box-text-check">
                    <select value={hardTerminalAutoMuteMode} onChange={this.changeHardTerminalAutoMuteMode}>
                      {TerminalAutoMuteTypeOptions.map(item => {
                        return <option value={item.value} key={item.value}>{item.label}</option>
                      })}
                    </select>
                  </div>
                </div>
                <div className="input-box">
                    <div className="input-box-title-check">concurrentParticipants:</div>
                    <div className="input-box-text"><input value={this.state.concurrentParticipants} onChange={this.changeConcurrentParticipants.bind(this)} /></div>
                </div>
                <hr />
                <div className="input-box">
                    <div className="input-box-title-check">Repeat:</div>
                    <div className="input-box-text-check"><input type="checkbox" checked={conferenceType === 1} disabled/></div>
                </div>
                {showCycleConf && <React.Fragment>
                    <div className="input-box">
                        <div className="input-box-title">cycleType:</div>
                        <div className="input-box-text">
                            <select value={cycleType} onChange={e => this.setState({ cycleParam: { ...cycleParam, cycleType: Number(e.target.value) } })}>
                                {getCycleTypeOptions().map((item) => {
                                  const { label, value } = item
                                  return <option key={value} value={value} title={label}>{label}</option>
                                })}
                            </select>
                        </div>
                    </div>
                    <div className="input-box">
                    <div className="input-box-title">interval:</div>
                        <div className="input-box-text">
                            <select value={interval} onChange={e => this.setState({ cycleParam: { ...cycleParam, interval: Number(e.target.value) } })}>
                                {intervalOptions.map((item) => {
                                  const { label, value } = item
                                  return <option key={value} value={value} title={label}>{label}</option>
                                })}
                            </select>
                        </div>
                    </div>
                    <div className="input-box">
                        <div className="input-box-title">listPoints:</div>
                        <div className="input-box-text">
                            <input value={listPoints}
                                onChange={e => this.setState({ cycleParam: { ...cycleParam, listPoints: e.target.value } })}
                                placeholder={listPointsExample}
                            />
                        </div>
                    </div>
                    <div className="input-box">
                        <div className="input-box-title">preRemindDays:</div>
                        <div className="input-box-text">
                            <input value={preRemindDays}
                                onChange={e => this.setState({ cycleParam: { ...cycleParam, preRemindDays: Number(e.target.value) } })}
                            />
                        </div>
                    </div>
                    <div className="input-box">
                        <div className="input-box-title">endDate:</div>
                        <div className="input-box-text">
                            <input value={endTimeStampStr}
                                onChange={e => this.changeEndDateStr(e)}
                                placeholder="timestemp"
                            />
                        </div>
                    </div>
                    <div className="input-box-long">
                        <div className="input-box-title-long">subConfParam:</div>
                        <ul className="sub-conf-list">
                                {subConfParam && subConfParam.map(subConf => {
                                  return (
                                        <li key={subConf.subConfID}>
                                            <span style={{ 'font-size': '15px' }}>{moment.unix(subConf.startTimeStamp).format(FORMAT_DATE_MINUTE)} - {moment.unix(subConf.endTimeStamp).format(FORMAT_DATE_MINUTE)}</span>
                                            <span className="btn" onClick={() => this.editCycleSubConf(subConf)}>Edit Conf</span>
                                            <span className="btn" onClick={() => this.cancelCycleSubConf(subConf)}>Cancel Conf</span>
                                        </li>
                                  )
                                })}
                        </ul>
                    </div>
                </React.Fragment>}
                <hr />
                <div className="input-box-long">
                    <div className="input-box-title-long">Attendees:</div>
                    <div className="input-box-text"><textarea value={this.state.attendees} onChange={this.changeAttendees.bind(this)} placeholder={this.state.attendeesExample} /></div>
                </div>
                <div className="input-box-long">
                    <div className="input-box-title-long">User Data:</div>
                    <div className="input-box-edit"><textarea value={this.state.customInfo} onChange={this.changeCustomInfo.bind(this)} /></div>
                </div>
                <button onClick={this.editConf.bind(this)}>Edit Conf</button>
                <button onClick={this.cancelConfById.bind(this)}>Cancel Conf</button>
                <button onClick={this.goBack.bind(this)}>Back</button>
                {isEditSubConf &&
                    <EditCycleSubConf
                        confId={confId}
                        subConf={curSubConf}
                        vmrId={vmrId}
                        allowGuestStartConfTimeDisable={allowGuestStartConfTimeDisable}
                        guestPwd={guestPwd}
                        vmrName={vmrName}
                        hostPwd={hostPwd}
                        onSuccess={() => this.editCycleSubConfSuccess()}
                        onClose={() => this.setState({ isEditSubConf: false })}
                    />
                }
            </div>
    )
  }
}

ConfInfo.propTypes = {
  deployType: PropTypes.oneOf([DeployType.SINK_MODE, DeployType.CLOUD_MODE]),
}

const mapStateToProps = (state) => {
  const { deployType } = state.setting.deploy
  return { deployType }
}

export default connect(mapStateToProps)(ConfInfo)
