import React from 'react'
import './index.less'
import ApiService from '../../../AppService/ApiService'
import { showErrorTips } from '../../../utils'

class ShowToast extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      content: '',
      duration: 5,
    }
  }

  changeContent (e) {
    this.setState({
      content: e.target.value,
    })
  }

  changeDuration (e) {
    this.setState({
      duration: Number(e.target.value),
    })
  }

  async showToast () {
    const { content, duration } = this.state
    const param = {
      content,
      duration,
    }
    const apiService = new ApiService()
    const setResult = await apiService.showToast(param)
    if (setResult.ret !== 0) {
      showErrorTips(setResult.ret, setResult.reason)
    }
  }

  goBack () {
    this.props.history.goBack()
  }

  render () {
    return (
      <div className="show-toast">
        <div className="input-box">
          <div className="input-box-title">content:</div>
          <div className="input-box-text">
            <input
              className="input-text"
              value={this.state.content}
              onChange={this.changeContent.bind(this)}
            />
          </div>
        </div>
        <div className="input-box">
          <div className="input-box-title">duration:</div>
          <div className="input-box-text">
            <input
              type='number'
              className="input-text"
              value={this.state.duration}
              onChange={this.changeDuration.bind(this)}
            />
          </div>
        </div>
        <button onClick={this.showToast.bind(this)}>Submit</button>
        <button onClick={this.goBack.bind(this)}>Back</button>
      </div>
    )
  }
}

export default ShowToast
