import { SDKERR} from './enum';
import { InjectParticipantItemBtnInfo, InjectBtnInfo, HwndListInfo, AvatarInfo, WaterMarkInfo, MainWindowInfo, ParticipantItemInfo, CallAllBtnInfo, ShowSettingWindowInfo, WindowIconInfo, ToastInfo, AvatarStyle, ContactInfo} from './model';
import { needCallWithIPC } from './util';
const electron = window.require('electron');

export class IUIConfig {
	addOn!: IUIConfig;
	_onClickInjectBtnNotifyCallback!: (injectBtnInfo: InjectBtnInfo) => void;
	_onClickInjectParticipantItemBtnNotifyCallback!: (injectBtnInfo: InjectParticipantItemBtnInfo) => void;
	_onClickInjectCallAllBtnNotifyCallback!: (injectBtnInfo: CallAllBtnInfo) => void;
	_onRenderWindowInfoListChangedCallback!: (hwndInfo: HwndListInfo) => void;
	_onQueryContactAvatarNotifyCallback!: (contactInfo: ContactInfo) => void;
	_onDoubleClickParticipantListItemNotifyCallback!: (participantInfo: ParticipantItemInfo) => void;
	_configCallback!: (ret: SDKERR, reason: string) => void;
	_setWaterMarkCallback!: (ret: SDKERR, reason: string) => void;
	_getRenderWindowInfoListCallback!: (ret: SDKERR, reason: string, hwndInfo: HwndListInfo) => void;
	_showMeetingWindowCallback!: (ret: SDKERR, reason: string) => void;
	_setAvatarCallback!: (ret: SDKERR, reason: string) => void;
	_setMeetingWindowIconCallback!: (ret: SDKERR, reason: string) => void;
	_showSettingWindowCallback!: (ret: SDKERR, reason: string) => void;
	_showToastCallback!: (ret: SDKERR, reason: string) => void;
	_getMainWindowInfoCallback!: (ret: SDKERR, reason: string, mainWindowInfo: MainWindowInfo) => void;
	_setAvatarStyleCallback!: (ret: SDKERR, reason: string) => void;
	_inProcessCallbackSet!: Set<string>;
	callWithIPC: boolean = false;
	constructor(addOn: IUIConfig) {
		this.addOn = addOn;
		this._inProcessCallbackSet = new Set<string>();
		this.callWithIPC = needCallWithIPC();
	}

	init(): void {
		this._inProcessCallbackSet.clear();
	}

	/**
	* [en] Notify of inject btn. [cn] 注入点击通知
	*/
	setOnClickInjectBtnNotifyCB(onClickInjectBtnNotify: (injectBtnInfo: InjectBtnInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnClickInjectBtnNotifyCB', {});
			electron.ipcRenderer.on('onClickInjectBtnNotify', (event: any, arg: any) => {
				if (onClickInjectBtnNotify) {
					onClickInjectBtnNotify(arg["injectBtnInfo"])
				}
			});
			return;
		}

		this._onClickInjectBtnNotifyCallback = (injectBtnInfo: InjectBtnInfo) => {
			if (onClickInjectBtnNotify) {
				onClickInjectBtnNotify(injectBtnInfo);
			}
		}
		this.addOn.setOnClickInjectBtnNotifyCB(this._onClickInjectBtnNotifyCallback);
	}

	/**
	* [en] Notify of inject participant item btn. [cn] 与会者列表子项注入点击通知
	*/
	setOnClickInjectParticipantItemBtnNotifyCB(onClickInjectParticipantItemBtnNotify: (injectBtnInfo: InjectParticipantItemBtnInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnClickInjectParticipantItemBtnNotifyCB', {});
			electron.ipcRenderer.on('onClickInjectParticipantItemBtnNotify', (event: any, arg: any) => {
				if (onClickInjectParticipantItemBtnNotify) {
					onClickInjectParticipantItemBtnNotify(arg["injectBtnInfo"])
				}
			});
			return;
		}

		this._onClickInjectParticipantItemBtnNotifyCallback = (injectBtnInfo: InjectParticipantItemBtnInfo) => {
			if (onClickInjectParticipantItemBtnNotify) {
				onClickInjectParticipantItemBtnNotify(injectBtnInfo);
			}
		}
		this.addOn.setOnClickInjectParticipantItemBtnNotifyCB(this._onClickInjectParticipantItemBtnNotifyCallback);
	}

	/**
	* [en] Notify of inject Call all btn. [cn] 全部呼叫注入点击通知
	*/
	setOnClickInjectCallAllBtnNotifyCB(onClickInjectCallAllBtnNotify: (injectBtnInfo: CallAllBtnInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnClickInjectCallAllBtnNotifyCB', {});
			electron.ipcRenderer.on('onClickInjectCallAllBtnNotify', (event: any, arg: any) => {
				if (onClickInjectCallAllBtnNotify) {
					onClickInjectCallAllBtnNotify(arg["injectBtnInfo"])
				}
			});
			return;
		}

		this._onClickInjectCallAllBtnNotifyCallback = (injectBtnInfo: CallAllBtnInfo) => {
			if (onClickInjectCallAllBtnNotify) {
				onClickInjectCallAllBtnNotify(injectBtnInfo);
			}
		}
		this.addOn.setOnClickInjectCallAllBtnNotifyCB(this._onClickInjectCallAllBtnNotifyCallback);
	}

	/**
	* [en] window handle list notify. when window handle changed, will receive this notify [cn] 窗口句柄通知
	*/
	setOnRenderWindowInfoListChangedCB(onRenderWindowInfoListChanged: (hwndInfo: HwndListInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnRenderWindowInfoListChangedCB', {});
			electron.ipcRenderer.on('onRenderWindowInfoListChanged', (event: any, arg: any) => {
				if (onRenderWindowInfoListChanged) {
					onRenderWindowInfoListChanged(arg["hwndInfo"])
				}
			});
			return;
		}

		this._onRenderWindowInfoListChangedCallback = (hwndInfo: HwndListInfo) => {
			if (onRenderWindowInfoListChanged) {
				onRenderWindowInfoListChanged(hwndInfo);
			}
		}
		this.addOn.setOnRenderWindowInfoListChangedCB(this._onRenderWindowInfoListChangedCallback);
	}

	/**
	* [en] Notify of query external contact avatar [cn] 查询外部通讯录头像通知
	*/
	setOnQueryContactAvatarNotifyCB(onQueryContactAvatarNotify: (contactInfo: ContactInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnQueryContactAvatarNotifyCB', {});
			electron.ipcRenderer.on('onQueryContactAvatarNotify', (event: any, arg: any) => {
				if (onQueryContactAvatarNotify) {
					onQueryContactAvatarNotify(arg["contactInfo"])
				}
			});
			return;
		}

		this._onQueryContactAvatarNotifyCallback = (contactInfo: ContactInfo) => {
			if (onQueryContactAvatarNotify) {
				onQueryContactAvatarNotify(contactInfo);
			}
		}
		this.addOn.setOnQueryContactAvatarNotifyCB(this._onQueryContactAvatarNotifyCallback);
	}

	/**
	* [en] Notify of double click participant list item [cn] 双击与会者项通知
	*/
	setOnDoubleClickParticipantListItemNotifyCB(onDoubleClickParticipantListItemNotify: (participantInfo: ParticipantItemInfo) => void): void {
		if (this.callWithIPC) {
			electron.ipcRenderer.sendSync('setOnDoubleClickParticipantListItemNotifyCB', {});
			electron.ipcRenderer.on('onDoubleClickParticipantListItemNotify', (event: any, arg: any) => {
				if (onDoubleClickParticipantListItemNotify) {
					onDoubleClickParticipantListItemNotify(arg["participantInfo"])
				}
			});
			return;
		}

		this._onDoubleClickParticipantListItemNotifyCallback = (participantInfo: ParticipantItemInfo) => {
			if (onDoubleClickParticipantListItemNotify) {
				onDoubleClickParticipantListItemNotify(participantInfo);
			}
		}
		this.addOn.setOnDoubleClickParticipantListItemNotifyCB(this._onDoubleClickParticipantListItemNotifyCallback);
	}

	/**
	* [en] This interface is used to config sdk. [cn] 界面配置
	*/
	config(uiConfig: string, onConfigResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("config")) {
			if (onConfigResult) {
				onConfigResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("config");
		this._configCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("config");
			if (onConfigResult) {
				onConfigResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('config', {"uiConfig":uiConfig}).then((ret: any) => {
				this._inProcessCallbackSet.delete('config');
				if (onConfigResult) {
					onConfigResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.config(uiConfig, this._configCallback);
	}

	/**
	* [en] This interface is used to set watermark inject information. [cn] 自定义会中水印
	*/
	setWaterMark(waterMarkInfo: WaterMarkInfo, onSetWaterMarkResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("setWaterMark")) {
			if (onSetWaterMarkResult) {
				onSetWaterMarkResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("setWaterMark");
		this._setWaterMarkCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("setWaterMark");
			if (onSetWaterMarkResult) {
				onSetWaterMarkResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('setWaterMark', {"waterMarkInfo":waterMarkInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('setWaterMark');
				if (onSetWaterMarkResult) {
					onSetWaterMarkResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.setWaterMark(waterMarkInfo, this._setWaterMarkCallback);
	}

	/**
	* [en] This method is used to get window handle list. [cn] 获取窗口句柄列表
	*/
	getRenderWindowInfoList(onGetRenderWindowInfoListResult?: (ret: SDKERR, reason: string, hwndInfo: HwndListInfo) => void): void {
		if (this._inProcessCallbackSet.has("getRenderWindowInfoList")) {
			if (onGetRenderWindowInfoListResult) {
				let nullResult = <HwndListInfo>{};
				onGetRenderWindowInfoListResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getRenderWindowInfoList");
		this._getRenderWindowInfoListCallback = (ret: SDKERR, reason: string, hwndInfo: HwndListInfo) => {
			this._inProcessCallbackSet.delete("getRenderWindowInfoList");
			if (onGetRenderWindowInfoListResult) {
				onGetRenderWindowInfoListResult(ret, reason, hwndInfo);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getRenderWindowInfoList', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getRenderWindowInfoList');
				if (onGetRenderWindowInfoListResult) {
					onGetRenderWindowInfoListResult(ret["ret"], ret["reason"], ret["hwndInfo"]);
				}
			});
		}

		this.addOn.getRenderWindowInfoList(this._getRenderWindowInfoListCallback);
	}

	/**
	* [en] This interface is used to ShowMeetingWindow. [cn] 显示会议窗口
	*/
	showMeetingWindow(onShowMeetingWindowResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("showMeetingWindow")) {
			if (onShowMeetingWindowResult) {
				onShowMeetingWindowResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("showMeetingWindow");
		this._showMeetingWindowCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("showMeetingWindow");
			if (onShowMeetingWindowResult) {
				onShowMeetingWindowResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('showMeetingWindow', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('showMeetingWindow');
				if (onShowMeetingWindowResult) {
					onShowMeetingWindowResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.showMeetingWindow(this._showMeetingWindowCallback);
	}

	/**
	* [en] This interface is used to set avatar. [cn] 设置头像
	*/
	setAvatar(avatarInfo: AvatarInfo, onSetAvatarResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("setAvatar")) {
			if (onSetAvatarResult) {
				onSetAvatarResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("setAvatar");
		this._setAvatarCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("setAvatar");
			if (onSetAvatarResult) {
				onSetAvatarResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('setAvatar', {"avatarInfo":avatarInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('setAvatar');
				if (onSetAvatarResult) {
					onSetAvatarResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.setAvatar(avatarInfo, this._setAvatarCallback);
	}

	/**
	* [en] This interface is used to set meeting window icon info. [cn] 自定义会议窗口任务栏图标
	*/
	setMeetingWindowIcon(windowIconInfo: WindowIconInfo, onSetMeetingWindowIconResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("setMeetingWindowIcon")) {
			if (onSetMeetingWindowIconResult) {
				onSetMeetingWindowIconResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("setMeetingWindowIcon");
		this._setMeetingWindowIconCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("setMeetingWindowIcon");
			if (onSetMeetingWindowIconResult) {
				onSetMeetingWindowIconResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('setMeetingWindowIcon', {"windowIconInfo":windowIconInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('setMeetingWindowIcon');
				if (onSetMeetingWindowIconResult) {
					onSetMeetingWindowIconResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.setMeetingWindowIcon(windowIconInfo, this._setMeetingWindowIconCallback);
	}

	/**
	* [en] This interface is used to show setting window. [cn] 显示设置窗口接口
	*/
	showSettingWindow(showInfo: ShowSettingWindowInfo, onShowSettingWindowResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("showSettingWindow")) {
			if (onShowSettingWindowResult) {
				onShowSettingWindowResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("showSettingWindow");
		this._showSettingWindowCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("showSettingWindow");
			if (onShowSettingWindowResult) {
				onShowSettingWindowResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('showSettingWindow', {"showInfo":showInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('showSettingWindow');
				if (onShowSettingWindowResult) {
					onShowSettingWindowResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.showSettingWindow(showInfo, this._showSettingWindowCallback);
	}

	/**
	* [en] This interface is used to show toast info. [cn] 显示提示信息
	*/
	showToast(toastInfo: ToastInfo, onShowToastResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("showToast")) {
			if (onShowToastResult) {
				onShowToastResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("showToast");
		this._showToastCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("showToast");
			if (onShowToastResult) {
				onShowToastResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('showToast', {"toastInfo":toastInfo}).then((ret: any) => {
				this._inProcessCallbackSet.delete('showToast');
				if (onShowToastResult) {
					onShowToastResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.showToast(toastInfo, this._showToastCallback);
	}

	/**
	* [en] This interface is used to get main window info. [cn] 获取主窗口信息
	*/
	getMainWindowInfo(onGetMainWindowInfoResult?: (ret: SDKERR, reason: string, mainWindowInfo: MainWindowInfo) => void): void {
		if (this._inProcessCallbackSet.has("getMainWindowInfo")) {
			if (onGetMainWindowInfoResult) {
				let nullResult = <MainWindowInfo>{};
				onGetMainWindowInfoResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process", nullResult);
			};
			return;
		}
		this._inProcessCallbackSet.add("getMainWindowInfo");
		this._getMainWindowInfoCallback = (ret: SDKERR, reason: string, mainWindowInfo: MainWindowInfo) => {
			this._inProcessCallbackSet.delete("getMainWindowInfo");
			if (onGetMainWindowInfoResult) {
				onGetMainWindowInfoResult(ret, reason, mainWindowInfo);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('getMainWindowInfo', {}).then((ret: any) => {
				this._inProcessCallbackSet.delete('getMainWindowInfo');
				if (onGetMainWindowInfoResult) {
					onGetMainWindowInfoResult(ret["ret"], ret["reason"], ret["mainWindowInfo"]);
				}
			});
		}

		this.addOn.getMainWindowInfo(this._getMainWindowInfoCallback);
	}

	/**
	* [en] This interface is used to set avatar style. [cn] 设置头像风格
	*/
	setAvatarStyle(avatarStyle: AvatarStyle, onSetAvatarStyleResult?: (ret: SDKERR, reason: string) => void): void {
		if (this._inProcessCallbackSet.has("setAvatarStyle")) {
			if (onSetAvatarStyleResult) {
				onSetAvatarStyleResult(SDKERR.UISDK_IN_PROCESS, "uisdk in process");
			};
			return;
		}
		this._inProcessCallbackSet.add("setAvatarStyle");
		this._setAvatarStyleCallback = (ret: SDKERR, reason: string) => {
			this._inProcessCallbackSet.delete("setAvatarStyle");
			if (onSetAvatarStyleResult) {
				onSetAvatarStyleResult(ret, reason);
			}
		}

		if (this.callWithIPC) {
			electron.ipcRenderer.invoke('setAvatarStyle', {"avatarStyle":avatarStyle}).then((ret: any) => {
				this._inProcessCallbackSet.delete('setAvatarStyle');
				if (onSetAvatarStyleResult) {
					onSetAvatarStyleResult(ret["ret"], ret["reason"]);
				}
			});
		}

		this.addOn.setAvatarStyle(avatarStyle, this._setAvatarStyleCallback);
	}

}

