//
//  HWMAttendeeInfo.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/13.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMAttendeeInfo : NSObject

/// （选填）账号、密码场景情况下，必填号码 ； appid情况下 选填， 账号必填
 @property (nonatomic, copy) NSString *number;

///（必填)与会者名称
@property (nonatomic, copy) NSString *name;

/// 会中显示的与会者名称 中文昵称
@property (nonatomic, copy) NSString *aliasCN;

/// 会中显示的与会者名称 英文昵称
@property (nonatomic, copy) NSString *aliasEN;

/// 用户登录帐号 若为用户名/密*码登录场景 必填
/// 创建会议、预约会议时添加与会人时，如果填了number（sip号），则accountId不用填
@property (nonatomic, copy) NSString *accountId;

/// 第三方用户帐号 AppID鉴权方式下 必填
@property (nonatomic, copy) NSString *thirdUserId;

/// 可选，电子邮箱地址
@property (nonatomic, copy) NSString *email;

/// 可选，短信通知手机号码
@property (nonatomic, copy) NSString *sms;

/// 可选，是否闭音
@property (nonatomic, assign) BOOL mute;

/// 可选，是否自动外呼, 默认开启
@property (nonatomic, assign) BOOL isAutoInvite;

///  可选(主动创建会议者，传递主持人，其他传递普通与会者） 会议成员角色
@property (nonatomic, assign) HWMConfRoleType  role;

/// APPID 登录场景下的 APPID，只读
@property (nonatomic, copy, readonly) NSString *appId;

/// 可选，会议用户类型
@property (nonatomic, assign) HWMConfAttendeeType type;

#pragma mark - 获取与会者列表使用
@property (nonatomic, assign) BOOL isAnonymous;  /**< 是否是匿名入会 */
@property (nonatomic, assign) HWMAttendeeState state; /**< 会中与会者状态 */
@property (nonatomic, copy) NSString *orgId; /**< 用于识别是否是本企业账号 */
@property (nonatomic, assign) BOOL isSelf;    /**< 是否是自己 */
@property (nonatomic, assign) NSUInteger userId;
@property (nonatomic, copy) NSString *extendedField;
@property (nonatomic, copy) NSString *realNameAccount;
/// 是否支持会中修改参数能力
@property (nonatomic, assign) BOOL hasModifyCustomInfoInConfCapability;

@end

NS_ASSUME_NONNULL_END
