//
//  HWMBaseJoinConfParam.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/12.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface HWMBaseJoinConfParam : NSObject
/// 会议id, 必填字段
@property(nonatomic, copy) NSString *confId;

/// 会议中的昵称。如果不传入，会使用设备名字  长度不超过64
@property(nonatomic, copy) NSString *nickname;

/// 会中显示的与会者名称 中文昵称
@property (nonatomic, copy) NSString *aliasCN;

/// 会中显示的与会者名称 英文昵称
@property (nonatomic, copy) NSString *aliasEN;

/// 是否打开摄像头.默认关闭
@property(nonatomic, assign) BOOL isCameraOn;

/// 是否打开麦克风。默认打开
@property(nonatomic, assign) BOOL isMicOn;

/// 是否打开扬声器。默认打开
@property(nonatomic, assign) BOOL isSpkOn;

/// 企业互信应用ID
@property (nonatomic, copy) NSString *corpTrustAppId;

/// 三方自定义字段
@property (nonatomic, copy) NSString *extendedField;

@end

NS_ASSUME_NONNULL_END
