//
//  HWMVirtualBackgroundParam.h
//  HWMUISDK
//
//  Created by lining on 2022/5/13.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMVirtualBackgroundImageModel.h"

// 设置虚拟背景默认图片方式
typedef NS_ENUM(NSInteger, HWMSettingVBDefaultImageMode) {
    HWMSettingVBDefaultImageModeReplaceAll, // 全部替换, 覆盖内置默认图片
    HWMSettingVBDefaultImageModeAppend      // 基于内置的默认图片追加
};

NS_ASSUME_NONNULL_BEGIN

@interface HWMVirtualBackgroundParam : NSObject

// 设置虚拟背景默认图片方式
@property (nonatomic, assign) HWMSettingVBDefaultImageMode mode;

/// 自定义虚拟背景默认图片数组
@property (nullable, nonatomic, strong) NSArray<HWMVirtualBackgroundImageModel *> *imageModels;

@end

NS_ASSUME_NONNULL_END
