//
//  HWMCallNotifyHandler.h
//  HWMUISDK
//
//  Created by guomeng on 2020/12/29.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"
#import "HWMCallRecordInfo.h"
#import "HWMCallIncomingInfo.h"

NS_ASSUME_NONNULL_BEGIN

@protocol HWMCallNotifyHandler <NSObject>

@optional

/// 点对点状态变更通知
/// @param status 呼叫状态
- (void)onCallStatusChanged:(HWMCallStatus)status DEPRECATED_ATTRIBUTE;

/// 通话结束通话记录通知
/// @param callInfo 通话记录
- (void)onCallEnded:(HWMCallRecordInfo *)callInfo DEPRECATED_ATTRIBUTE;

/// 点对点来电通知
/// @param callIncomingInfo 来电信息
- (void)onCallIncoming:(HWMCallIncomingInfo *)callIncomingInfo DEPRECATED_ATTRIBUTE;

@end

NS_ASSUME_NONNULL_END
