const { ipcMain,app } = require('electron');
const os = require('os');
const path = require('path');
const fs = require('fs');

const platform = os.platform();
const arch = os.arch();
function getNodePath() {
	let _platformArch = 'win32';
	if (platform === 'darwin') {
		if (arch === 'arm64') {
			_platformArch = 'mac-arm64';
		} else {
			_platformArch = 'mac';
		}
	} else if (arch === 'x64') {
		_platformArch = 'x64';
	}
	let _path = `../../../sdk/${_platformArch}/`;
	let nodePath = path.join(__dirname, _path + 'HwmUisdk.node');
	if (!fs.existsSync(nodePath)) {
		_path = `../sdk/${_platformArch}/`;
		nodePath = path.join(__dirname, _path + 'HwmUisdk.node');
	}
	return nodePath;
}

/**
* 建议放在BrowserWindow创建好后, windowFrame.loadFile()之前调用
* @param {BrowserWindow} windowFrame 窗口对象
*/
function initIPCHandlers(windowFrame) {
	let nodePath = getNodePath();
	const api = require(nodePath);
	console.log('init IPCHandlers');

	ipcMain.on('setOnKickedOutNotifyCB', (event, arg) => {
		const callback = () => {
			windowFrame.webContents.send('onKickedOutNotify', {});
		};
		api.setOnKickedOutNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnCorpConfigNotifyCB', (event, arg) => {
		const callback = (configInfo) => {
			windowFrame.webContents.send('onCorpConfigNotify', {"configInfo": configInfo});
		};
		api.setOnCorpConfigNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnUserCorpInfoChangedCB', (event, arg) => {
		const callback = (type) => {
			windowFrame.webContents.send('onUserCorpInfoChanged', {"type": type});
		};
		api.setOnUserCorpInfoChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnLoginErrorNotifyCB', (event, arg) => {
		const callback = (ret, reason) => {
			windowFrame.webContents.send('onLoginErrorNotify', {"ret": ret, "reason": reason});
		};
		api.setOnLoginErrorNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnShareVmrInfoNotifyCB', (event, arg) => {
		const callback = (shareVmrInfo) => {
			windowFrame.webContents.send('onShareVmrInfoNotify', {"shareVmrInfo": shareVmrInfo});
		};
		api.setOnShareVmrInfoNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnLoginStateChangeNotifyCB', (event, arg) => {
		const callback = (loginStateInfo) => {
			windowFrame.webContents.send('onLoginStateChangeNotify', {"loginStateInfo": loginStateInfo});
		};
		api.setOnLoginStateChangeNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.handle('loginByAccount', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, loginResult) => {
				resolve({"ret": ret, "reason": reason, "loginResult": loginResult});
			}
			api.loginByAccount(arg["accountAuthInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('loginByAppId', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, loginResult) => {
				resolve({"ret": ret, "reason": reason, "loginResult": loginResult});
			}
			api.loginByAppId(arg["appIdAuthInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('loginBySSO', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, loginResult) => {
				resolve({"ret": ret, "reason": reason, "loginResult": loginResult});
			}
			api.loginBySSO(arg["ssoAuthInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('logout', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, logoutResult) => {
				resolve({"ret": ret, "reason": reason, "logoutResult": logoutResult});
			}
			api.logout(callback);
		});
		return ret;
	});

	ipcMain.handle('setNetworkMode', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setNetworkMode(arg["networkInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('uploadSelfAvatar', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.uploadSelfAvatar(arg["selfAvatarInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('deleteSelfAvatar', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.deleteSelfAvatar(callback);
		});
		return ret;
	});

	ipcMain.on('setGuaranteedIpAddresses', (event, arg) => {
		const ret = api.setGuaranteedIpAddresses(arg["guaranteedIpAddresses"]);
		event.returnValue = ret;
	});

	ipcMain.handle('setGlobalGuaranteedIpAddresses', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setGlobalGuaranteedIpAddresses(arg["guaranteedIpAddressesParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('setServerAddress', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setServerAddress(arg["serverInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setProxy', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setProxy(arg["proxyInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setCAVerifyInfo', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setCAVerifyInfo(arg["CAVerifyInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('getLoginState', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, loginStateInfo) => {
				resolve({"ret": ret, "reason": reason, "loginStateInfo": loginStateInfo});
			}
			api.getLoginState(callback);
		});
		return ret;
	});

	ipcMain.handle('getLoginToken', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, loginTokenInfo) => {
				resolve({"ret": ret, "reason": reason, "loginTokenInfo": loginTokenInfo});
			}
			api.getLoginToken(callback);
		});
		return ret;
	});

	ipcMain.on('setOnConfStateChangedCB', (event, arg) => {
		const callback = (confStateInfo) => {
			windowFrame.webContents.send('onConfStateChanged', {"confStateInfo": confStateInfo});
		};
		api.setOnConfStateChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnConfEndedNotifyCB', (event, arg) => {
		const callback = (confEndInfo) => {
			windowFrame.webContents.send('onConfEndedNotify', {"confEndInfo": confEndInfo});
		};
		api.setOnConfEndedNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnP2PConfRecordNotifyCB', (event, arg) => {
		const callback = (recordInfo) => {
			windowFrame.webContents.send('onP2PConfRecordNotify', {"recordInfo": recordInfo});
		};
		api.setOnP2PConfRecordNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnConfInfoNotifyCB', (event, arg) => {
		const callback = (confInfo) => {
			windowFrame.webContents.send('onConfInfoNotify', {"confInfo": confInfo});
		};
		api.setOnConfInfoNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnShareStateChangedCB', (event, arg) => {
		const callback = (shareStateInfo) => {
			windowFrame.webContents.send('onShareStateChanged', {"shareStateInfo": shareStateInfo});
		};
		api.setOnShareStateChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnRecvShareStateChangedCB', (event, arg) => {
		const callback = (shareStateInfo) => {
			windowFrame.webContents.send('onRecvShareStateChanged', {"shareStateInfo": shareStateInfo});
		};
		api.setOnRecvShareStateChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnSelfRoleChangedCB', (event, arg) => {
		const callback = (role) => {
			windowFrame.webContents.send('onSelfRoleChanged', {"role": role});
		};
		api.setOnSelfRoleChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnPoorNetworkQualityInfoNotifyCB', (event, arg) => {
		const callback = (poorNetWorkInfo) => {
			windowFrame.webContents.send('onPoorNetworkQualityInfoNotify', {"poorNetWorkInfo": poorNetWorkInfo});
		};
		api.setOnPoorNetworkQualityInfoNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnMeetingInfoChangedCB', (event, arg) => {
		const callback = (meetingInfo) => {
			windowFrame.webContents.send('onMeetingInfoChanged', {"meetingInfo": meetingInfo});
		};
		api.setOnMeetingInfoChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnWaitingListChangedCB', (event, arg) => {
		const callback = (waitingList) => {
			windowFrame.webContents.send('onWaitingListChanged', {"waitingList": waitingList});
		};
		api.setOnWaitingListChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnAddAttendeeNotifyCB', (event, arg) => {
		const callback = (addAttendeeResultList) => {
			windowFrame.webContents.send('onAddAttendeeNotify', {"addAttendeeResultList": addAttendeeResultList});
		};
		api.setOnAddAttendeeNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnSelfLocalRecordStateNotifyCB', (event, arg) => {
		const callback = (localRecordStateInfo) => {
			windowFrame.webContents.send('onSelfLocalRecordStateNotify', {"localRecordStateInfo": localRecordStateInfo});
		};
		api.setOnSelfLocalRecordStateNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnAttendeeListChangedCB', (event, arg) => {
		const callback = (attendeeList) => {
			windowFrame.webContents.send('onAttendeeListChanged', {"attendeeList": attendeeList});
		};
		api.setOnAttendeeListChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnRealTimeSubtitleInfoNotifyCB', (event, arg) => {
		const callback = (realTimeSubtitleInfo) => {
			windowFrame.webContents.send('onRealTimeSubtitleInfoNotify', {"realTimeSubtitleInfo": realTimeSubtitleInfo});
		};
		api.setOnRealTimeSubtitleInfoNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnSubtitleRecordNotifyCB', (event, arg) => {
		const callback = (subtitleRecordInfo) => {
			windowFrame.webContents.send('onSubtitleRecordNotify', {"subtitleRecordInfo": subtitleRecordInfo});
		};
		api.setOnSubtitleRecordNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnSubtitleStateChangedCB', (event, arg) => {
		const callback = (isOpen) => {
			windowFrame.webContents.send('onSubtitleStateChanged', {"isOpen": isOpen});
		};
		api.setOnSubtitleStateChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnWaitingRoomStateChangedCB', (event, arg) => {
		const callback = (isOpen) => {
			windowFrame.webContents.send('onWaitingRoomStateChanged', {"isOpen": isOpen});
		};
		api.setOnWaitingRoomStateChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnStartLocalRecordOperationInterruptNotifyCB', (event, arg) => {
		const callback = (info) => {
			windowFrame.webContents.send('onStartLocalRecordOperationInterruptNotify', {"info": info});
		};
		api.setOnStartLocalRecordOperationInterruptNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnConfForbiddenScreenShotsEnableChangedCB', (event, arg) => {
		const callback = (enableType) => {
			windowFrame.webContents.send('onConfForbiddenScreenShotsEnableChanged', {"enableType": enableType});
		};
		api.setOnConfForbiddenScreenShotsEnableChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.handle('createConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, createConfResult) => {
				resolve({"ret": ret, "reason": reason, "createConfResult": createConfResult});
			}
			api.createConf(arg["createConfInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('startP2pConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, createConfResult) => {
				resolve({"ret": ret, "reason": reason, "createConfResult": createConfResult});
			}
			api.startP2pConf(arg["startCallInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('joinConfById', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.joinConfById(arg["joinConfByIdInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('joinConfByRandom', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.joinConfByRandom(arg["joinConfByRandomInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('addAttendee', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.addAttendee(arg["addAttendeeInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('leaveConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.leaveConf(callback);
		});
		return ret;
	});

	ipcMain.handle('endConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.endConf(callback);
		});
		return ret;
	});

	ipcMain.handle('startShare', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.startShare(arg["startShareInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('stopShare', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.stopShare(callback);
		});
		return ret;
	});

	ipcMain.handle('getAttendeeList', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, attendeeList) => {
				resolve({"ret": ret, "reason": reason, "attendeeList": attendeeList});
			}
			api.getAttendeeList(callback);
		});
		return ret;
	});

	ipcMain.handle('getAudienceList', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, audidenceList) => {
				resolve({"ret": ret, "reason": reason, "audidenceList": audidenceList});
			}
			api.getAudienceList(callback);
		});
		return ret;
	});

	ipcMain.handle('getUserState', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, userState) => {
				resolve({"ret": ret, "reason": reason, "userState": userState});
			}
			api.getUserState(callback);
		});
		return ret;
	});

	ipcMain.handle('getSelfRole', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, selfRole) => {
				resolve({"ret": ret, "reason": reason, "selfRole": selfRole});
			}
			api.getSelfRole(callback);
		});
		return ret;
	});

	ipcMain.handle('renameSelf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.renameSelf(arg["renameSelfInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('startProjection', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, startProjectionResult) => {
				resolve({"ret": ret, "reason": reason, "startProjectionResult": startProjectionResult});
			}
			api.startProjection(arg["startProjectionParam"], callback);
		});
		return ret;
	});

	ipcMain.on('setAutoHideToolBar', (event, arg) => {
		const ret = api.setAutoHideToolBar(arg["autoHideToolBarParam"]);
		event.returnValue = ret;
	});

	ipcMain.handle('acceptConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.acceptConf(arg["acceptConfParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('rejectConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.rejectConf(callback);
		});
		return ret;
	});

	ipcMain.handle('getSelfShareState', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, selfShareStateInfo) => {
				resolve({"ret": ret, "reason": reason, "selfShareStateInfo": selfShareStateInfo});
			}
			api.getSelfShareState(callback);
		});
		return ret;
	});

	ipcMain.handle('openSubtitle', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, isOpen) => {
				resolve({"ret": ret, "reason": reason, "isOpen": isOpen});
			}
			api.openSubtitle(arg["isOpen"], callback);
		});
		return ret;
	});

	ipcMain.handle('openWaitingRoom', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, isOpen) => {
				resolve({"ret": ret, "reason": reason, "isOpen": isOpen});
			}
			api.openWaitingRoom(arg["isOpen"], callback);
		});
		return ret;
	});

	ipcMain.handle('operateLocalRecord', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, type) => {
				resolve({"ret": ret, "reason": reason, "type": type});
			}
			api.operateLocalRecord(arg["type"], callback);
		});
		return ret;
	});

	ipcMain.handle('openVirtualBackgroundSettingPage', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.openVirtualBackgroundSettingPage(callback);
		});
		return ret;
	});

	ipcMain.handle('getConfLocalRecordStatus', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, state) => {
				resolve({"ret": ret, "reason": reason, "state": state});
			}
			api.getConfLocalRecordStatus(callback);
		});
		return ret;
	});

	ipcMain.handle('getSelfHasLocalRecordPermission', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, permission) => {
				resolve({"ret": ret, "reason": reason, "permission": permission});
			}
			api.getSelfHasLocalRecordPermission(callback);
		});
		return ret;
	});

	ipcMain.handle('requestLocalRecordPermission', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.requestLocalRecordPermission(callback);
		});
		return ret;
	});

	ipcMain.handle('applyHostRole', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.applyHostRole(arg["password"], callback);
		});
		return ret;
	});

	ipcMain.handle('getSubtitlePageOpened', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, isOpen) => {
				resolve({"ret": ret, "reason": reason, "isOpen": isOpen});
			}
			api.getSubtitlePageOpened(callback);
		});
		return ret;
	});

	ipcMain.handle('getWaitingRoomOpened', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, isOpen) => {
				resolve({"ret": ret, "reason": reason, "isOpen": isOpen});
			}
			api.getWaitingRoomOpened(callback);
		});
		return ret;
	});

	ipcMain.handle('getVirtualBackgroundSettingPageOpened', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, isOpen) => {
				resolve({"ret": ret, "reason": reason, "isOpen": isOpen});
			}
			api.getVirtualBackgroundSettingPageOpened(callback);
		});
		return ret;
	});

	ipcMain.handle('subscribeSubtitleLanguage', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, targetLanguageType) => {
				resolve({"ret": ret, "reason": reason, "targetLanguageType": targetLanguageType});
			}
			api.subscribeSubtitleLanguage(arg["targetLanguageType"], callback);
		});
		return ret;
	});

	ipcMain.handle('subscribeSubtitle', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, isSubscirbe) => {
				resolve({"ret": ret, "reason": reason, "isSubscirbe": isSubscirbe});
			}
			api.subscribeSubtitle(arg["isSubscribe"], callback);
		});
		return ret;
	});

	ipcMain.handle('getSubtitleSupportLanguage', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, targetLanguageTypeList) => {
				resolve({"ret": ret, "reason": reason, "targetLanguageTypeList": targetLanguageTypeList});
			}
			api.getSubtitleSupportLanguage(callback);
		});
		return ret;
	});

	ipcMain.on('setOnConfIncomingNotifyCB', (event, arg) => {
		const callback = (confIncomingInfo) => {
			windowFrame.webContents.send('onConfIncomingNotify', {"confIncomingInfo": confIncomingInfo});
		};
		api.setOnConfIncomingNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnConfListChangedCB', (event, arg) => {
		const callback = (confListInfo) => {
			windowFrame.webContents.send('onConfListChanged', {"confListInfo": confListInfo});
		};
		api.setOnConfListChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnCreateConfFinishedNotifyCB', (event, arg) => {
		const callback = (ret, reason, createConfResult) => {
			windowFrame.webContents.send('onCreateConfFinishedNotify', {"ret": ret, "reason": reason, "createConfResult": createConfResult});
		};
		api.setOnCreateConfFinishedNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.handle('bookConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, confDetail) => {
				resolve({"ret": ret, "reason": reason, "confDetail": confDetail});
			}
			api.bookConf(arg["bookConfParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('cancelConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.cancelConf(arg["cancelConfParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('editConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.editConf(arg["editConfParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('getVmrList', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, vmrListInfo) => {
				resolve({"ret": ret, "reason": reason, "vmrListInfo": vmrListInfo});
			}
			api.getVmrList(callback);
		});
		return ret;
	});

	ipcMain.handle('getConfDetail', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, confDetail) => {
				resolve({"ret": ret, "reason": reason, "confDetail": confDetail});
			}
			api.getConfDetail(arg["getConfDetailParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('changeVmrInfo', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.changeVmrInfo(arg["vmrInfoParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('getConfList', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, confListInfo) => {
				resolve({"ret": ret, "reason": reason, "confListInfo": confListInfo});
			}
			api.getConfList(callback);
		});
		return ret;
	});

	ipcMain.handle('bookCycleConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, confDetail) => {
				resolve({"ret": ret, "reason": reason, "confDetail": confDetail});
			}
			api.bookCycleConf(arg["bookCycleConfParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('modifyCycleConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.modifyCycleConf(arg["modifyParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('modifySubCycleConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.modifySubCycleConf(arg["modifySubCycleConfParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('cancelCycleConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.cancelCycleConf(arg["cancelCycleConfParam"], callback);
		});
		return ret;
	});

	ipcMain.handle('cancelSubCycleConf', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.cancelSubCycleConf(arg["cancelSubCycleConfParam"], callback);
		});
		return ret;
	});

	ipcMain.on('setOnAVDeviceCtrlStateChangedCB', (event, arg) => {
		const callback = (info) => {
			windowFrame.webContents.send('onAVDeviceCtrlStateChanged', {"info": info});
		};
		api.setOnAVDeviceCtrlStateChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnAudioFrameNotifyCB', (event, arg) => {
		const callback = (audioFrameData) => {
			windowFrame.webContents.send('onAudioFrameNotify', {"audioFrameData": audioFrameData});
		};
		api.setOnAudioFrameNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnShowVoiceprintStatementCB', (event, arg) => {
		const callback = (info) => {
			windowFrame.webContents.send('onShowVoiceprintStatement', {"info": info});
		};
		api.setOnShowVoiceprintStatementCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnUserSavePathChangedCB', (event, arg) => {
		const callback = (userSavePathInfo) => {
			windowFrame.webContents.send('onUserSavePathChanged', {"userSavePathInfo": userSavePathInfo});
		};
		api.setOnUserSavePathChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.handle('enableCapability', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.enableCapability(arg["capabilityInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setLanguage', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setLanguage(arg["languageInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setUserSavePath', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setUserSavePath(arg["userSavePathInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('getUserSavePath', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, pathInfo) => {
				resolve({"ret": ret, "reason": reason, "pathInfo": pathInfo});
			}
			api.getUserSavePath(arg["pathType"], callback);
		});
		return ret;
	});

	ipcMain.handle('setShareStrategy', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setShareStrategy(arg["shareStrategyInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setAudioRawDataOutputConfig', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setAudioRawDataOutputConfig(arg["audioRawDataConfigInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setAnswerType', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setAnswerType(arg["inComingAnswerTypeInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setDeviceConfigForConfIncoming', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setDeviceConfigForConfIncoming(arg["deviceConfig"], callback);
		});
		return ret;
	});

	ipcMain.handle('getConfPstnAccessNumber', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, pstnAccessNumberInfo) => {
				resolve({"ret": ret, "reason": reason, "pstnAccessNumberInfo": pstnAccessNumberInfo});
			}
			api.getConfPstnAccessNumber(callback);
		});
		return ret;
	});

	ipcMain.handle('aVDeviceCtrl', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, deviceCtrlInfo) => {
				resolve({"ret": ret, "reason": reason, "deviceCtrlInfo": deviceCtrlInfo});
			}
			api.aVDeviceCtrl(arg["deviceStateInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('disableVoicePrompts', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.disableVoicePrompts(arg["voicePromptsInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setShareScreenPermission', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setShareScreenPermission(arg["permission"], callback);
		});
		return ret;
	});

	ipcMain.handle('agreeVoiceprintStatement', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.agreeVoiceprintStatement(arg["isAgreed"], callback);
		});
		return ret;
	});

	ipcMain.handle('showVoiceprintRecordWindow', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.showVoiceprintRecordWindow(arg["isShow"], callback);
		});
		return ret;
	});

	ipcMain.handle('setLogPath', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setLogPath(arg["logPathInfo"], callback);
		});
		return ret;
	});

	ipcMain.on('getErrorMessage', (event, arg) => {
		const ret = api.getErrorMessage(arg["errorCode"]);
		event.returnValue = ret;
	});

	ipcMain.handle('setTransparentWnd', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setTransparentWnd(arg["wndInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setCustomUIText', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setCustomUIText(arg["customSceneTextInfoList"], callback);
		});
		return ret;
	});

	ipcMain.handle('setCustomUIImage', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setCustomUIImage(arg["customSceneImageInfoList"], callback);
		});
		return ret;
	});

	ipcMain.handle('setVirtualBackgroundDefaultImages', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setVirtualBackgroundDefaultImages(arg["defaultImagesInfo"], callback);
		});
		return ret;
	});

	ipcMain.on('setOnClickInjectBtnNotifyCB', (event, arg) => {
		const callback = (injectBtnInfo) => {
			windowFrame.webContents.send('onClickInjectBtnNotify', {"injectBtnInfo": injectBtnInfo});
		};
		api.setOnClickInjectBtnNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnClickInjectParticipantItemBtnNotifyCB', (event, arg) => {
		const callback = (injectBtnInfo) => {
			windowFrame.webContents.send('onClickInjectParticipantItemBtnNotify', {"injectBtnInfo": injectBtnInfo});
		};
		api.setOnClickInjectParticipantItemBtnNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnClickInjectCallAllBtnNotifyCB', (event, arg) => {
		const callback = (injectBtnInfo) => {
			windowFrame.webContents.send('onClickInjectCallAllBtnNotify', {"injectBtnInfo": injectBtnInfo});
		};
		api.setOnClickInjectCallAllBtnNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnRenderWindowInfoListChangedCB', (event, arg) => {
		const callback = (hwndInfo) => {
			windowFrame.webContents.send('onRenderWindowInfoListChanged', {"hwndInfo": hwndInfo});
		};
		api.setOnRenderWindowInfoListChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnQueryContactAvatarNotifyCB', (event, arg) => {
		const callback = (contactInfo) => {
			windowFrame.webContents.send('onQueryContactAvatarNotify', {"contactInfo": contactInfo});
		};
		api.setOnQueryContactAvatarNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnDoubleClickParticipantListItemNotifyCB', (event, arg) => {
		const callback = (participantInfo) => {
			windowFrame.webContents.send('onDoubleClickParticipantListItemNotify', {"participantInfo": participantInfo});
		};
		api.setOnDoubleClickParticipantListItemNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.handle('config', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.config(arg["uiConfig"], callback);
		});
		return ret;
	});

	ipcMain.handle('setWaterMark', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setWaterMark(arg["waterMarkInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('getRenderWindowInfoList', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, hwndInfo) => {
				resolve({"ret": ret, "reason": reason, "hwndInfo": hwndInfo});
			}
			api.getRenderWindowInfoList(callback);
		});
		return ret;
	});

	ipcMain.handle('showMeetingWindow', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.showMeetingWindow(callback);
		});
		return ret;
	});

	ipcMain.handle('setAvatar', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setAvatar(arg["avatarInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('setMeetingWindowIcon', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setMeetingWindowIcon(arg["windowIconInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('showSettingWindow', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.showSettingWindow(arg["showInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('showToast', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.showToast(arg["toastInfo"], callback);
		});
		return ret;
	});

	ipcMain.handle('getMainWindowInfo', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason, mainWindowInfo) => {
				resolve({"ret": ret, "reason": reason, "mainWindowInfo": mainWindowInfo});
			}
			api.getMainWindowInfo(callback);
		});
		return ret;
	});

	ipcMain.handle('setAvatarStyle', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.setAvatarStyle(arg["avatarStyle"], callback);
		});
		return ret;
	});

	ipcMain.on('setOnCallStateChangedCB', (event, arg) => {
		const callback = (callStateInfo) => {
			windowFrame.webContents.send('onCallStateChanged', {"callStateInfo": callStateInfo});
		};
		api.setOnCallStateChangedCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('setOnCallEndedNotifyCB', (event, arg) => {
		const callback = (callRecordInfo) => {
			windowFrame.webContents.send('onCallEndedNotify', {"callRecordInfo": callRecordInfo});
		};
		api.setOnCallEndedNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.handle('startCall', async (event, arg) => {
		const ret = new Promise((resolve, reject) => {
			const callback = (ret, reason) => {
				resolve({"ret": ret, "reason": reason});
			}
			api.startCall(arg["startCallInfo"], callback);
		});
		return ret;
	});

	ipcMain.on('setOnSdkDisconnectedNotifyCB', (event, arg) => {
		const callback = () => {
			windowFrame.webContents.send('onSdkDisconnectedNotify', {});
		};
		api.setOnSdkDisconnectedNotifyCB(callback);
		event.returnValue = 0;
	})

	ipcMain.on('init', (event, arg) => {
		const ret = api.init(arg["initInfo"]);
		event.returnValue = ret;
	});

	ipcMain.on('exit', (event, arg) => {
		const ret = api.exit();
		event.returnValue = ret;
	});

	ipcMain.on('getLoginApi', (event, arg) => {
		const ret = api.getLoginApi();
		event.returnValue = ret;
	});

	ipcMain.on('getConfCtrlApi', (event, arg) => {
		const ret = api.getConfCtrlApi();
		event.returnValue = ret;
	});

	ipcMain.on('getConfMgrApi', (event, arg) => {
		const ret = api.getConfMgrApi();
		event.returnValue = ret;
	});

	ipcMain.on('getConfigApi', (event, arg) => {
		const ret = api.getConfigApi();
		event.returnValue = ret;
	});

	ipcMain.on('getUIConfigApi', (event, arg) => {
		const ret = api.getUIConfigApi();
		event.returnValue = ret;
	});

	ipcMain.on('getCallApi', (event, arg) => {
		const ret = api.getCallApi();
		event.returnValue = ret;
	});

}

module.exports = { initIPCHandlers }
