const electron = require("electron");
const { app, BrowserWindow, Menu, globalShortcut, ipcMain, dialog } = electron;
const os = require('os');
const fs = require('fs'); 
const platform = os.platform();
const arch = os.arch();
app.allowRendererProcessReuse = false
const path = require("path");
const { initIPCHandlers } = require('./IPCHandlers')
global.remoteVars = {
  win: null,
  startTime: Date.now(),
  Sno: null
};

global.remoteVars.Sno = (function () {
  let sno = 0;
  return function () {
    return sno >= 65535 ? sno = 1 : ++sno;
  };
})();

// 二进制库的路径加入环境变量
let dllPath = './../sdk/win32/';
if (platform === 'darwin') {
  if (arch === 'arm64') {
    dllPath = './../sdk/mac-arm64/';
  } else {
    dllPath = './../sdk/mac/';
  }
} else if (arch === 'x64') {
  dllPath = './../sdk/x64/';
}
let envPath = path.join(__dirname, dllPath);
console.log("dllpath : ", envPath);
process.env.PATH = process.env.PATH + path.delimiter + envPath;
console.warn(process.env.PATH);
console.log("node : ", process.versions.node);
console.log("electron : ", process.versions.electron);
console.log("modules : ", process.versions.modules);
let win;
Menu.setApplicationMenu(null);
function createWindow() {
  // 创建浏览器窗口
  win = new BrowserWindow({
    width: 300,
    height: 500,
    resizable: false,
    webPreferences: {
      nodeIntegration: true,
      contextIsolation: false
    }
  })

  // 加载index.html文件
  // 本地npm run auto时,index.html所在路径
  let indexHtmlUrl = path.join(__dirname, './dist/index.html');
  if (!fs.existsSync(indexHtmlUrl)) {
    // 路径不存在时,说明是打成安装包,此时index.html所在路径修正
    console.log("index html in current path");
    indexHtmlUrl = path.join(__dirname, './index.html');
  }

  // Mac平台，electron版本 >= 25.0.0 的时候，必需要开启initIPCHandlers来解决方法调用卡死的问题,通过主进程进行调用addon
  initIPCHandlers(win)

  // 去掉地址中的%, 否则浏览器加载会失败
  win.loadFile(indexHtmlUrl.replace(/%/g, '%25'))

  global.remoteVars.win = win;
  win.webContents.openDevTools({mode:'detach'});

  win.on('focus', () => {
    // mac下注册快捷键
    if (process.platform === 'darwin') {
      let contents = win.webContents;
      globalShortcut.register('CommandOrControl+X', () => {
        contents.cut();
      })

      globalShortcut.register('CommandOrControl+V', () => {
        contents.paste();
      })

      globalShortcut.register('CommandOrControl+C', () => {
        contents.copy();
      })

      globalShortcut.register('CommandOrControl+A', () => {
        contents.selectAll();
      })
    }
  })

  win.on('blur', () => {
    // mac下注销键盘事件
    if (process.platform === 'darwin') {
      globalShortcut.unregisterAll();
    }
  })

  return win;
}

app.whenReady().then(createWindow)

// mac杀进程通知
app.on('before-quit', () => {
  if (process.platform === 'darwin') {
    win.webContents.send("app-going-to-quit");
  }
})

app.commandLine.appendSwitch('ignore-certificate-errors', true);

// 打开添加与会者窗口
ipcMain.on("show-add-attendee-window", () => {
  console.log("show-add-attendee-window");
  win.setAlwaysOnTop(true);
  win.setAlwaysOnTop(false);
});

// 显示报错弹框窗口
ipcMain.on("show-error-alert", (event, arg) => {
  dialog.showMessageBox({
    type: 'info',
    title: 'Notify',
    message: arg,
    buttons: ['ok']
  });
})