//
//  ActionModel.h
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/4.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface ActionModel : NSObject
@property (nonatomic, copy) NSString *title;
@property (nonatomic, copy, nullable) NSString *actionCtrl;
@property (nonatomic, assign)SEL action;
@property (nonatomic, assign)NSInteger type; // model 类型
@property (nonatomic, copy) NSString *accessibilityId;

+ (instancetype)initWithTitle:(NSString *)title
                       action:(SEL)action;
+ (instancetype)initWithTitle:(NSString *)title
                       action:(SEL)action
              accessibilityId:(NSString *)accessibilityId;

+ (instancetype)initWithTitle:(NSString *)title
                   actionCtrl:(nullable NSString *)ctrl;
+ (instancetype)initWithTitle:(NSString *)title
                   actionCtrl:(nullable NSString *)ctrl
              accessibilityId:(NSString *)accessibilityId;

+ (instancetype)initWithTitle:(NSString *)title type:(NSInteger)type;
+ (instancetype)initWithTitle:(NSString *)title type:(NSInteger)type accessibilityId:(NSString *)accessibilityId;
@end

NS_ASSUME_NONNULL_END
