



//
//  BaseViewController.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "BaseViewController.h"
#import "UIUtil.h"

@interface BaseViewController ()

@end

@implementation BaseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    
    [self setupViews];
}

- (void)setupViews {
//    if ([UIUtil getLaunchType] == HWMUISDKLaunchTypePresent) {
//        self.backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
//        self.backBtn.frame = CGRectMake(0, 40, 80, 30);
//        [self.view addSubview:self.backBtn];
//        [self.backBtn setTitleColor:HexColor(0x333333) forState:UIControlStateNormal];
//        [self.backBtn setTitle:@"返回" forState:UIControlStateNormal];
//        [self.backBtn addTarget:self action:@selector(back) forControlEvents:UIControlEventTouchUpInside];
//    }
    UIActivityIndicatorView *activityIndicator = [[UIActivityIndicatorView alloc]initWithActivityIndicatorStyle:(UIActivityIndicatorViewStyleGray)];
    [[UIApplication sharedApplication].keyWindow addSubview:activityIndicator];
    activityIndicator.frame= self.view.bounds;
    activityIndicator.color = [UIColor blackColor];
    activityIndicator.backgroundColor = [UIColor colorWithWhite:0 alpha:0.3];
    self.activityIndicator = activityIndicator;
}

- (void)back {
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)showLoading {
    [self.activityIndicator startAnimating];
}

- (void)hideLoading {
    [self.activityIndicator stopAnimating];
}

-(void)dealloc {
    NSLog(@"%@", [self class]);
}

- (void)pushViewControllerWithVcString:(NSString *)vcString {
    UIViewController * vc = [[NSClassFromString(vcString) alloc] init];
    [self.navigationController pushViewController:vc animated:YES];
}

- (BOOL)isLaunchTypePush {
    return [UIUtil getLaunchType] == HWMUISDKLaunchTypePush;
}

-(void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self.view endEditing:YES];
}

- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation{
    UIViewController *topPresentCtrl = [UIUtil findTopPresentViewController:self];
    if (topPresentCtrl) {
        return topPresentCtrl.preferredInterfaceOrientationForPresentation;
    }
    return  UIInterfaceOrientationPortrait;
}

- (UIInterfaceOrientationMask)supportedInterfaceOrientations{
    UIViewController *topPresentCtrl = [UIUtil findTopPresentViewController:self];
    if (topPresentCtrl) {
        return topPresentCtrl.supportedInterfaceOrientations;
    }
        return UIInterfaceOrientationMaskPortrait;

}

- (BOOL)shouldAutorotate {
     UIViewController *topPresentCtrl = [UIUtil findTopPresentViewController:self];
       if (topPresentCtrl) {
           return topPresentCtrl.shouldAutorotate;
       }
        return NO;
}

@end
