//
//  TableViewCell.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "TableViewCell.h"
#import "UIUtil.h"
@implementation TableViewCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleDefault;
        self.titleLabel = [[UILabel alloc] init];
        [self.contentView addSubview:self.titleLabel];
        self.titleLabel.font = [UIFont systemFontOfSize: 16];
        self.titleLabel.textColor = HexColor(0x333333);
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(30);
            make.centerY.mas_equalTo(0);
        }];
        
        self.selectTypeSwitch = [[UISwitch alloc] init];
        [self.contentView addSubview:self.selectTypeSwitch];
        [self.selectTypeSwitch addTarget:self action:@selector(selectSwitchChanged:) forControlEvents:(UIControlEventValueChanged)];
        [self.selectTypeSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
              make.centerY.mas_equalTo(self.titleLabel);
              make.right.mas_equalTo(-50);
          }];
        self.selectTypeSwitch.hidden = YES;
        
        UILabel * lineLabel = [[UILabel alloc] init];
        [self.contentView addSubview:lineLabel];
        lineLabel.backgroundColor = HexColor(0xf2f2f2);
        [lineLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.mas_equalTo(0);
            make.height.mas_equalTo(1);
            make.left.mas_equalTo(30);
            make.right.mas_equalTo(-30);
        }];
    }
    return self;
}

-(void)selectSwitchChanged:(UISwitch *)swt {
    if (self.selectTypeSwitch) {
        self.selectSwitchBlock(swt.isOn);
    }
}

@end
