//
//  CycleConfViewController.h
//  HWMSDKDemo
//
//  Created by 付细华 on 2021/10/20.
//  Copyright © 2021 HuaWei. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <HWMUISDK/HWMUISDK.h>

///周期会议操作类型
typedef NS_ENUM(NSUInteger, HWMCycleConfOperationType) {
    HWMCycleConfOperationTypeBook = 0,          //!<  预约周期会议
    HWMCycleConfOperationTypeEdit,              //!<  编辑周期会议
    HWMCycleConfOperationTypeEditSubConf        //!<  编辑周期子会议
};

NS_ASSUME_NONNULL_BEGIN

@interface CycleConfViewController : UIViewController
@property (nonatomic ,assign) HWMCycleConfOperationType operationType;
@property (nonatomic ,strong) HWMConfDetail *confDetail;
@property (nonatomic ,strong) HWMSDKSubCycleConfParamModel *subConfInfo;
@property (nonatomic ,strong) HWMOrderCycleConfParam *cycleConfInfo;
@end

NS_ASSUME_NONNULL_END
