//
//  SelectDataView.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/8/13.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "SelectDateView.h"

@interface SelectDateView()
@property (nonatomic, strong) UIDatePicker *dataPicker;

@end

@implementation SelectDateView

-(instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        UIView * bgView = [[UIView alloc] init];
        [bgView addTapAction:@selector(bgViewClick) target:self];
        bgView.backgroundColor = [UIColor colorWithWhite:0 alpha:0.3];
        [self addSubview:bgView];
        [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.mas_equalTo(self);
        }];
        
        UIView * contentView = [[UIView alloc] init];
        contentView.backgroundColor = [UIColor whiteColor];
        [bgView addSubview:contentView];
        [contentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.mas_equalTo(0);
            make.height.mas_equalTo(300);
        }];
        self.dataPicker = [[UIDatePicker alloc] init];
        self.dataPicker.backgroundColor = [UIColor whiteColor];
        self.dataPicker.datePickerMode = UIDatePickerModeDateAndTime;
        self.dataPicker.locale = [NSLocale localeWithLocaleIdentifier:@"zh"];
        self.dataPicker.accessibilityIdentifier = HWMSelectDatePicker;
        [self.dataPicker setMinimumDate:[NSDate date]];
        if (@available(iOS 13.4, *)) {
            self.dataPicker.preferredDatePickerStyle = UIDatePickerStyleWheels;
        }
        [contentView addSubview:self.dataPicker];
        [self.dataPicker mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.mas_equalTo(0);
            make.height.mas_equalTo(250);
        }];
        
        UIButton * cancelBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self addSubview:cancelBtn];
        [cancelBtn setTitle:@"取消" forState:UIControlStateNormal];
        cancelBtn.accessibilityIdentifier = HWMSelectDateCancel;
        [cancelBtn setTitleColor:HexColor(0x333333) forState:UIControlStateNormal];
        [cancelBtn addTarget:self action:@selector(cancelBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [cancelBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.mas_equalTo(self.dataPicker.mas_top);
            make.left.mas_equalTo(50);
        }];
        
        UIButton * confirmBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self addSubview:confirmBtn];
        [confirmBtn setTitle:@"确定" forState:UIControlStateNormal];
        confirmBtn.accessibilityIdentifier = HWMSelectDateConfirm;
        [confirmBtn setTitleColor:HexColor(0x333333) forState:UIControlStateNormal];
        [confirmBtn addTarget:self action:@selector(confirmBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.mas_equalTo(self.dataPicker.mas_top);
            make.right.mas_equalTo(-50);
        }];
        
    }
    return self;
}

- (void)cancelBtnClick {
    [self removeFromSuperview];
}

- (void)bgViewClick {
    [self removeFromSuperview];
}

- (void)confirmBtnClick {
    NSDateFormatter * formatter = [[NSDateFormatter alloc] init];
    formatter.dateFormat = @"yyyy-MM-dd HH:mm";
    NSString * dateStr = [formatter stringFromDate:self.dataPicker.date];
    if (self.dateChange) {
        self.dateChange(dateStr);
    }
    [self removeFromSuperview];
}

@end
