



//
//  CallViewController.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "CallViewController.h"
#import "SelectWayView.h"

@interface CallViewController ()
@property (nonatomic, strong) UITextField *phoneTextField;
@property (nonatomic, strong) UITextField *accountTextField;
@property (nonatomic, assign) BOOL selectAudio;

@end

@implementation CallViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"发起呼叫";
}

- (void)setupViews {
    [super setupViews];
    self.phoneTextField = [[UITextField alloc] init];
    [self.view addSubview:self.phoneTextField];
    self.phoneTextField.placeholder = @"被呼号码";
    [self.phoneTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(110);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    [UIView addBottomLineWithView:self.phoneTextField parentView:self.view];
    
    self.accountTextField = [[UITextField alloc] init];
    [self.view addSubview:self.accountTextField];
    self.accountTextField.placeholder = @"被呼账号";
    [self.accountTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.phoneTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.phoneTextField);
        make.left.right.mas_equalTo(self.phoneTextField);
    }];
    [UIView addBottomLineWithView:self.accountTextField parentView:self.view];
    
    SelectWayView * selectView = [[SelectWayView alloc] init];
    [self.view addSubview:selectView];
    self.selectAudio = YES;
    __weak __typeof(self) weakSelf = self;
    selectView.selectBlcok = ^(SelectType type) {
        weakSelf.selectAudio = type;
    };
    [selectView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.accountTextField.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(self.phoneTextField);
        make.height.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    
    
    UIButton * callBtn = [UIButton newButtonWithTitle:@"发起呼叫"];
    [self.view addSubview:callBtn];
    [callBtn addTarget:self action:@selector(initiateCall) forControlEvents:UIControlEventTouchUpInside];
    [callBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(selectView.mas_bottom).mas_offset(50);
        make.left.right.mas_equalTo(self.accountTextField);
        make.height.mas_equalTo(50);
    }];
    
}


- (void)initiateCall {
    NSLog(@"发起呼叫,%zd", self.selectAudio);
}




@end
