//
//  ConfControlViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/6/23.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "ConfControlViewController.h"
#import <HWMUISDK/HWMUISDK.h>

typedef NS_ENUM(NSInteger, ConfControlCellType) {
    ConfControlCellTypeOpenSubtitle,
    ConfControlCellTypeCloseSubtitle,
    ConfControlCellTypeOpenWaitingRoom,
    ConfControlCellTypeCloseWaitingRoom,
    ConfControlCellTypeApplyHostRole,
    ConfControlCellTypeOpenVBSettingPage,
    ConfControlCellTypeSubscribeSubtitleNotify,
    ConfControlCellTypeUnsubscribeSubtitleNotify,
    ConfControlCellTypeSubscribeSubtitleLanguage,
};

@interface ConfControlViewController ()

@end

@implementation ConfControlViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas{
    self.dataArray = @[[ActionModel initWithTitle:@"开启字幕" type:ConfControlCellTypeOpenSubtitle],
                       [ActionModel initWithTitle:@"关闭字幕" type:ConfControlCellTypeCloseSubtitle],
                       [ActionModel initWithTitle:@"开启等候室" type:ConfControlCellTypeOpenWaitingRoom],
                       [ActionModel initWithTitle:@"关闭等候室" type:ConfControlCellTypeCloseWaitingRoom],
                       [ActionModel initWithTitle:@"申请主持人" type:ConfControlCellTypeApplyHostRole],
                       [ActionModel initWithTitle:@"打开虚拟背景设置" type:ConfControlCellTypeOpenVBSettingPage],
                       [ActionModel initWithTitle:@"订阅字幕通知" type:ConfControlCellTypeSubscribeSubtitleNotify],
                       [ActionModel initWithTitle:@"取消订阅字幕通知" type:ConfControlCellTypeUnsubscribeSubtitleNotify],
                       [ActionModel initWithTitle:@"订阅字幕翻译语言" type:ConfControlCellTypeSubscribeSubtitleLanguage],
    ];
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.selectTypeSwitch.hidden = YES;
    cell.accessibilityIdentifier = model.accessibilityId;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    ActionModel *model = self.dataArray[indexPath.row];
    switch (model.type) {
        case ConfControlCellTypeOpenSubtitle: {
            [self handleOpenSubtitle:YES];
        }
            break;
        case ConfControlCellTypeCloseSubtitle: {
            [self handleOpenSubtitle:NO];
        }
            break;
        case ConfControlCellTypeOpenWaitingRoom: {
            [self handleOpenWaitingRoom:YES];
        }
            break;
        case ConfControlCellTypeCloseWaitingRoom: {
            [self handleOpenWaitingRoom:NO];
        }
            break;
        case ConfControlCellTypeApplyHostRole: {
            [self handleApplyHostRole];
        }
            break;
        case ConfControlCellTypeOpenVBSettingPage: {
            [self handleOpenVBSettingPage];
        }
            break;
        case ConfControlCellTypeSubscribeSubtitleNotify: {
            [self handleSubscribeSubtitleNotify:YES];
        }
            break;
        case ConfControlCellTypeUnsubscribeSubtitleNotify: {
            [self handleSubscribeSubtitleNotify:NO];
        }
            break;
        case ConfControlCellTypeSubscribeSubtitleLanguage: {
            [self handleSubtitleSupportLanguage];
        }
            break;
        default:
            break;
    }
}

- (void)handleOpenSubtitle:(BOOL)isOpen {
    [[HWMBizSdk getBizOpenApi] openSubtitle:isOpen callback:^(NSError * _Nullable error, id  _Nullable result) {
        [UIUtil showMessage:@"成功" error:error];
    }];
}

- (void)handleOpenWaitingRoom:(BOOL)isOpen {
    [[HWMBizSdk getBizOpenApi] openWaitingRoom:isOpen callback:^(NSError * _Nullable error, id  _Nullable result) {
        [UIUtil showMessage:@"成功" error:error];
    }];
}

- (void)handleApplyHostRole {
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"请求主持人" message:nil preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
    }];
    UIAlertAction *confirm = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        NSString *pwd = alert.textFields.firstObject.text;
        [[HWMBizSdk getBizOpenApi] applyHostRole:pwd callback:^(NSError * _Nullable error, id  _Nullable result) {
            [UIUtil showMessage:@"成功" error:error];
        }];
    }];
    [alert addAction:cancel];
    [alert addAction:confirm];
    [alert addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder = @"请输入密码";
    }];
    [self presentViewController:alert animated:YES completion:nil];
}

- (void)handleOpenVBSettingPage {
    [[HWMBizSdk getBizOpenApi] openVirtualBackgroundSettingPageWithCallback:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [UIUtil showMessageWithError:error];
        }
    }];
}

- (void)handleSubscribeSubtitleNotify:(BOOL)isSubscribe {
    [[HWMBizSdk getBizOpenApi] subscribeSubtitle:isSubscribe callback:^(NSError * _Nullable error, id  _Nullable result) {
        [UIUtil showMessage:@"成功" error:error];
    }];
}

- (void)handleSubtitleSupportLanguage {
    [self pushViewControllerWithVcString:@"SubtitleSupportLanguageViewController"];
}

@end
