//
//  SubtitleSupportLanguageViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/6/28.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "SubtitleSupportLanguageViewController.h"
#import <HWMUISDK/HWMUISDK.h>

@interface SubtitleSupportLanguageViewController ()

@end

@implementation SubtitleSupportLanguageViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"字幕翻译语言";
    
    NSMutableArray<ActionModel *> *datas = [[NSMutableArray alloc] init];
    NSArray<HWMSubtitleLanguageInfoModel *> *supportLanguages = [[HWMBizSdk getBizOpenApi] getSubtitleSupportLanguage];
    [supportLanguages enumerateObjectsUsingBlock:^(HWMSubtitleLanguageInfoModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        ActionModel *model = [ActionModel initWithTitle:[self convertLanguageDesc:obj.languageType] type:obj.languageType];
        [datas addObject:model];
    }];
    self.dataArray = datas.copy;
    
    [self setupTableView];
}

- (NSString *)convertLanguageDesc:(HWMTargetLanguageType)type {
    switch (type) {
        case HWMSDKSubtitleLanguageCn:
            return @"中文";
        case HWMSDKSubtitleLanguageEn:
            return @"英文";
        case HWMSDKSubtitleLanguageGe:
            return @"德文";
        case HWMSDKSubtitleLanguageFr:
            return @"法语";
        case HWMSDKSubtitleLanguageRu:
            return @"俄语";
        case HWMSDKSubtitleLanguageJa:
            return @"日语";
        case HWMSDKSubtitleLanguageKo:
            return @"韩语";
        case HWMSDKSubtitleLanguageEs:
            return @"西班牙语";
        case HWMSDKSubtitleLanguagePt:
            return @"葡萄牙语";
        case HWMSDKSubtitleLanguageAr:
            return @"阿拉伯语";
        case HWMSDKSubtitleLanguageIt:
            return @"意大利语";
        case HWMSDKSubtitleLanguageTh:
            return @"泰语";
        case HWMSDKSubtitleLanguageId:
            return @"印度尼西亚语";
        case HWMSDKSubtitleLanguageMs:
            return @"马来语";
        case HWMSDKSubtitleLanguageTr:
            return @"土耳其语";
        default:
            return @"不翻译";
    }
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
    cell.selectTypeSwitch.hidden = YES;
    cell.accessibilityIdentifier = model.accessibilityId;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    ActionModel *model = self.dataArray[indexPath.row];
    HWMSDKERR ret = [[HWMBizSdk getBizOpenApi] subscribeSubtitleLanguage:model.type];
    if (ret == HWMSDKSdkerrSuccess) {
        [UIUtil showMessage:@"订阅成功"];
    } else {
        [UIUtil showMessage:[NSString stringWithFormat:@"订阅失败: %ld", ret]];
    }
}

@end
