//
//  NotifyDataSource.h
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/8/3.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <HWMUISDK/HWMUISDK.h>
#import "NotifyMessageModel.h"
NS_ASSUME_NONNULL_BEGIN

@protocol NotifyMessageDelegate <NSObject>

- (void)onMessageChanged:(NSArray *)datas;

@end

@protocol SubtitleNotifyDelegate <NSObject>

- (void)onRealTimeNotify:(NSString *)content;
- (void)onRecordNotify:(NSString *)content;

@end

@interface NotifyMessageHandler : NSObject <HWMNotifyHandler, HWMBizNotificationHandler, HWMBizNotificationHandler, HWMConfUIHandler>

@property(nonatomic, strong)NSMutableArray  <NotifyMessageModel *> * notifyMessages;
@property(nonatomic, weak)id  <NotifyMessageDelegate> delegate;
@property(nonatomic, weak)id  <SubtitleNotifyDelegate> subtitleDelegate;

+ (instancetype)sharedInstance;
@end

NS_ASSUME_NONNULL_END
