//
//  SubtitleRecordViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/6/27.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "SubtitleRecordViewController.h"
#import "NotifyMessageHandler.h"

@interface SubtitleRecordViewController () <SubtitleNotifyDelegate>

@property (weak, nonatomic) IBOutlet UITextView *realTimeSubtitleTV;
@property (weak, nonatomic) IBOutlet UITextView *subtitleRecordTV;

@property (nonatomic, strong) NSMutableString *realTimeSubtitleContent;
@property (nonatomic, strong) NSMutableString *subtitleRecordContent;

@end

@implementation SubtitleRecordViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"字幕消息通知";
    [NotifyMessageHandler sharedInstance].subtitleDelegate = self;
    self.realTimeSubtitleContent = [[NSMutableString alloc] init];
    self.subtitleRecordContent = [[NSMutableString alloc] init];
}

- (void)onRealTimeNotify:(NSString *)content {
    [self.realTimeSubtitleContent appendFormat:@"\n%@", content];
    self.realTimeSubtitleTV.text = self.realTimeSubtitleContent;
}

- (void)onRecordNotify:(NSString *)content {
    [self.subtitleRecordContent appendFormat:@"\n%@", content];
    self.subtitleRecordTV.text = self.subtitleRecordContent;
}

@end
