//
//  ConfListTableViewCell.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/8/12.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "ConfListTableViewCell.h"

@implementation ConfListTableViewCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.cancelBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self addSubview:self.cancelBtn];
        [self.cancelBtn setTitle:@"取消会议" forState:UIControlStateNormal];
        [self.cancelBtn setTitleColor:HexColor(0x1E90FF) forState:UIControlStateNormal];
        self.cancelBtn.titleLabel.font = [UIFont systemFontOfSize:14];
        [self.cancelBtn addTarget:self action:@selector(cancelBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [self.cancelBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(-20);
            make.top.mas_equalTo(10);
        }];
        
        self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self addSubview:self.editBtn];
        [self.editBtn setTitle:@"编辑会议" forState:UIControlStateNormal];
        [self.editBtn setTitleColor:HexColor(0x1E90FF) forState:UIControlStateNormal];
        self.editBtn.titleLabel.font = [UIFont systemFontOfSize:14];
        [self.editBtn addTarget:self action:@selector(editBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [self.editBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.mas_equalTo(self.cancelBtn);
            make.top.mas_equalTo(self.cancelBtn.mas_bottom).mas_offset(10);
        }];
        
        self.subCycleConfBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self addSubview:self.subCycleConfBtn];
        [self.subCycleConfBtn setTitle:@"子会议" forState:UIControlStateNormal];
        [self.subCycleConfBtn setTitleColor:HexColor(0x1E90FF) forState:UIControlStateNormal];
        self.subCycleConfBtn.titleLabel.font = [UIFont systemFontOfSize:14];
        [self.subCycleConfBtn addTarget:self action:@selector(subCycleConfBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [self.subCycleConfBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.mas_equalTo(self.editBtn);
            make.top.mas_equalTo(self.editBtn.mas_bottom).mas_offset(10);
        }];
    }
    return self;
}

- (void)cancelBtnClick {
    if (self.clickEvent) {
        self.clickEvent(BtnTypeCancelConf);
    }
}

- (void)editBtnClick {
    if (self.clickEvent) {
        self.clickEvent(BtnTypeEditConf);
    }
}

- (void)subCycleConfBtnClick {
    if (self.clickEvent) {
        self.clickEvent(BtnTypeSubCycleConf);
    }
}

@end
