//
//  AttendeesViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2021/7/8.
//  Copyright © 2021 HuaWei. All rights reserved.
//

#import "AttendeesViewController.h"
#import "TableViewCell.h"

@interface AttendeesViewController ()

@property (nonatomic, strong) NSArray <HWMAttendeeInfo *> *attendees;
@end

@implementation AttendeesViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"与会人列表";
    [self initData];

    [self setupTableView];
}

- (void)initData {
    if (self.type == ListTypeAttendee) {
        self.attendees = [[HWMBizSdk getBizOpenApi] getAttendeeList];
    } else {
        self.attendees = [[HWMBizSdk getBizOpenApi] getAudienceList];
    }
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.attendees.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    HWMAttendeeInfo * attendeeInfo = self.attendees[indexPath.row];
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    cell.titleLabel.numberOfLines = 0;
    NSString * content = [NSString stringWithFormat:@"昵称：%@\n昵称(中文)：%@\n昵称(英文)：%@\n账号：%@\n三方账号：%@\n会议状态:%@\norgid：%@\n是否匿名：%@\n会议中角色：%@\nnumber：%@\n", attendeeInfo.name,attendeeInfo.aliasCN, attendeeInfo.aliasEN,attendeeInfo.accountId, attendeeInfo.thirdUserId, [self getStateStr:attendeeInfo.state], attendeeInfo.orgId, attendeeInfo.isAnonymous? @"是":@"否",[self getRoleStr:attendeeInfo.role],attendeeInfo.number];
    cell.titleLabel.text = content;
    [cell.titleLabel mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(10);
        make.left.mas_equalTo(30);
        make.right.mas_equalTo(-30);
        make.bottom.mas_equalTo(-10);
    }];
    return cell;
}

- (NSString *)getStateStr:(HWMConfAttendeeState)state {
    switch (state) {
        case HWMConfAttendeeStateInConf:
            return @"会议中";
        case HWMConfAttendeeStateCalling:
            return @"正在呼叫";
        case HWMConfAttendeeStateJoining:
            return @"正在加入会议";
        case HWMConfAttendeeStateLeaved:
            return @"已经离开";
        case HWMConfAttendeeStateNoExist:
            return @"用户不存在";
        case HWMConfAttendeeStateBusy:
            return @"被叫用户忙";
        case HWMConfAttendeeStateNoAnswer:
            return @"用户无应答";
        case HWMConfAttendeeStateReject:
            return @"用户拒绝接听";
        case HWMConfAttendeeStateFailed:
            return @"呼叫失败";
        default:
            return @"未知";
    }
}

- (NSString *)getRoleStr:(ConfRoleType)type {
    switch (type) {
        case ConfRoleTypeAttendee:
            return @"与会者";
        case ConfRoleTypeChairman:
            return @"主席";
        case ConfRoleTypeAudience:
            return @"观众";
        case ConfRoleTypeCohost:
            return @"联席主席";
        default:
            return @"";
    }
}

- (NSArray<HWMAttendeeInfo *> *)attendees {
    if (!_attendees) {
        _attendees = [NSMutableArray array];
    }
    return _attendees;
}

@end
