//
//  NewMeetingViewController.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "NewMeetingViewController.h"
#import "SelectWayView.h"
@interface NewMeetingViewController ()
@property (nonatomic, strong) UITextField *meetingNameTextField;
@property (nonatomic, assign) BOOL selectAudio;
@property (nonatomic, assign) BOOL needPwd;                             // 是否需要密码
@property (nonatomic, assign) BOOL needJoin;                            // 是否需要与会者
@property (nonatomic, strong) UIView *joinView;
@property (nonatomic, strong) UITextField *joinAccountOneTextField;     //与会者账号
@property (nonatomic, strong) UITextField *joinNameOneTextField;        // 与会者名字
@property (nonatomic, strong) UITextField *joinAccountTwoTextField;     //与会者账号
@property (nonatomic, strong) UITextField *joinNameTwoTextField;        // 与会者名字


@property (nonatomic, strong) UISwitch *pwdSwitch;
@property (nonatomic, strong) UISwitch *joinSwitch;

@property (nonatomic, strong) UIButton * meetingBtn;
@end

@implementation NewMeetingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"创建会议";
}

- (void)setupViews {
    [super setupViews];
    self.meetingNameTextField = [[UITextField alloc] init];
    [self.view addSubview:self.meetingNameTextField];
    self.meetingNameTextField.placeholder = @"会议主题";
    [self.meetingNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(110);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    [UIView addBottomLineWithView:self.meetingNameTextField parentView:self.view];
    
    
    SelectWayView * selectView = [[SelectWayView alloc] init];
    [self.view addSubview:selectView];
    self.selectAudio = YES;
    __weak __typeof(self) weakSelf = self;
    selectView.selectBlcok = ^(SelectType type) {
        weakSelf.selectAudio = type;
    };
    [selectView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.meetingNameTextField.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(self.meetingNameTextField);
        make.height.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    
    
    UILabel * pwdLabel = [self newLabelWithTitle:@"是否需要密码"];
    [self.view addSubview:pwdLabel];
    [pwdLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(selectView.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(selectView);
    }];
    
    self.pwdSwitch = [[UISwitch alloc] init];
    [self.view addSubview:self.pwdSwitch];
    self.pwdSwitch.selected = NO;
    [self.pwdSwitch addTarget:self action:@selector(pwdSwitchChanged:) forControlEvents:(UIControlEventValueChanged)];
    [self.pwdSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(pwdLabel);
        make.right.mas_equalTo(-50);
    }];
    
    UILabel * attendLabel = [self newLabelWithTitle:@"是否需要携带与会者"];
    [self.view addSubview:attendLabel];
    [attendLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(pwdLabel.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(selectView);
    }];
    
    self.joinSwitch = [[UISwitch alloc] init];
    [self.view addSubview:self.joinSwitch];
    self.joinSwitch.selected = NO;
    [self.joinSwitch addTarget:self action:@selector(joinSwitchChanged:) forControlEvents:(UIControlEventValueChanged)];
    [self.joinSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(attendLabel);
        make.right.mas_equalTo(-50);
    }];
    
    self.joinView = [[UIView alloc] init];
    self.joinView.hidden = YES;
    [self.view addSubview:self.joinView];
    [self.joinView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(attendLabel.mas_bottom).mas_offset(20);
        make.left.right.mas_equalTo(self.meetingNameTextField);
    }];
    
    UILabel * joinOneLabel = [[UILabel alloc] init];
    [self.joinView addSubview:joinOneLabel];
    joinOneLabel.text = @"与会者1:";
    [joinOneLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.top.mas_equalTo(0);
    }];
    
    self.joinAccountOneTextField = [[UITextField alloc] init];
    [self.joinView addSubview:self.joinAccountOneTextField];
    self.joinAccountOneTextField.placeholder = @"与会者1账号";
    [self.joinAccountOneTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(joinOneLabel.mas_bottom).mas_offset(10);
        make.height.mas_equalTo(30);
        make.left.right.mas_equalTo(0);
    }];
    [UIView addBottomLineWithView:self.joinAccountOneTextField parentView:self.joinView];
    
    self.joinNameOneTextField = [[UITextField alloc] init];
    [self.joinView addSubview:self.joinNameOneTextField];
    self.joinNameOneTextField.placeholder = @"与会者1昵称";
    [self.joinNameOneTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.joinAccountOneTextField.mas_bottom).mas_offset(15);
        make.height.mas_equalTo(30);
        make.left.right.mas_equalTo(0);
    }];
    [UIView addBottomLineWithView:self.joinNameOneTextField parentView:self.joinView];
    
    UILabel * joinTwoLabel = [[UILabel alloc] init];
    [self.joinView addSubview:joinTwoLabel];
    joinTwoLabel.text = @"与会者2:";
    [joinTwoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.top.mas_equalTo(self.joinNameOneTextField.mas_bottom).mas_offset(20);
    }];
    
    self.joinAccountTwoTextField = [[UITextField alloc] init];
    [self.joinView addSubview:self.joinAccountTwoTextField];
    self.joinAccountTwoTextField.placeholder = @"与会者2账号";
    [self.joinAccountTwoTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(joinTwoLabel.mas_bottom).mas_offset(15);
        make.height.mas_equalTo(30);
        make.left.right.mas_equalTo(0);
    }];
    [UIView addBottomLineWithView:self.joinAccountTwoTextField parentView:self.joinView];
    
    self.joinNameTwoTextField = [[UITextField alloc] init];
    [self.joinView addSubview:self.joinNameTwoTextField];
    self.joinNameTwoTextField.placeholder = @"与会者2昵称";
    [self.joinNameTwoTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.joinAccountTwoTextField.mas_bottom).mas_offset(15);
        make.height.mas_equalTo(30);
        make.left.right.mas_equalTo(0);
    }];
    [UIView addBottomLineWithView:self.joinNameTwoTextField parentView:self.joinView];
    
    [self.joinView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.joinNameTwoTextField.mas_bottom).mas_offset(2);
    }];
    
    self.meetingBtn = [UIButton newButtonWithTitle:@"创建会议"];
    [self.view addSubview:self.meetingBtn];
    [self.meetingBtn addTarget:self action:@selector(newMeeting) forControlEvents:UIControlEventTouchUpInside];
    [self.meetingBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(attendLabel.mas_bottom).mas_offset(50);
        make.left.right.mas_equalTo(self.meetingNameTextField);
        make.height.mas_equalTo(50);
    }];
}

- (void)pwdSwitchChanged:(UISwitch *)swt {
    self.needPwd = swt.isOn;
}

- (void)joinSwitchChanged:(UISwitch *)swt {
    self.needJoin = swt.isOn;
    self.joinView.hidden = !swt.isOn;
    [self.meetingBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        if(self.needJoin) {
            make.top.mas_equalTo(self.joinView.mas_bottom).mas_offset(50);
        }
        else {
            make.top.mas_equalTo(self.joinView.mas_top).mas_offset(30);
        }
        make.left.right.mas_equalTo(self.meetingNameTextField);
        make.height.mas_equalTo(50);
    }];
    
}

- (void)newMeeting {
    NSLog(@"创建会议=");
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel * label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

@end
