//
//  CreateMeetingViewController.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "CreateMeetingViewController.h"
#import "MediaTypeSwitchView.h"
#import <HWMUISDK/HWMUISDK.h>
#import "UIUtil.h"
#import <HWMUISDK/HWMPrivateApi.h>
#import "CommonUtil.h"

@interface CreateMeetingViewController ()
@property (nonatomic, strong) UIScrollView *scrollView;
@property (nonatomic, strong) UITextField *subjectTextField;
@property (nonatomic, strong) UITextField *customInfoTextField;
@property (nonatomic, strong) HWMUITextField *concurrentParticipantsTextField;
@property (nonatomic, assign) BOOL isVideoSelect;
@property (nonatomic, assign) BOOL needPwd;         // 是否需要密码
@property (nonatomic, assign) BOOL needMembers;        // 是否需要与会者
@property (nonatomic, strong) UITextView *memberView;

@property (nonatomic, strong) UISwitch *pwdSwitch;
@property (nonatomic, strong) UISwitch *joinSwitch;

@property (nonatomic, strong) UISwitch *cameraSwitch;
@property (nonatomic, strong) UISwitch *micSwitch;
@property (nonatomic, strong) UISwitch *recordSwitch;
@property (nonatomic, strong) UISwitch *autoRecordSwitch;
@property (nonatomic, strong) UISwitch *vmrIdTypeSwitch;
@property (nonatomic, strong) UISwitch *supportWatermarkSwitch;
@property (nonatomic, strong) UISwitch *waitingRoomSwitch;
@property (nonatomic, strong) UISwitch *earpieceSwitch;

@property (nonatomic, strong) UIButton * meetingBtn;
@property (nonatomic, strong) NSArray <HWMContactSelectedModel *>*selectedMemebrs;
@property (nonatomic, strong) HWMCreateConfParam *creatConfParam;
@property (nonatomic, strong) NSArray<HWMVmrInfoModel *> *vmrList;
@property (nonatomic, strong) UILabel *joinConfRestrictionLabel;
@property (nonatomic, strong) UISwitch *personalIDSwitch;
@property (nonatomic, strong) MediaTypeSwitchView * selectView;
@property (nonatomic, strong) UILabel *confIdTypeLabel;
@property (nonatomic, strong) HWMUITextField *pwdTextField;
@property (nonatomic, strong) UIView *vmrIdTypeView;
@property (nonatomic, assign) BOOL isEnableShareVmr;
@property (nonatomic, strong) UILabel *autoMuteLabel;
@property (nonatomic, strong) UILabel *hardTerminalAutoMuteLabel;
@property (nonatomic, strong) UISwitch *summarySwitch;
@property (nonatomic, strong) UISwitch *autoPublishSummarySwitch;
@property (nonatomic, strong) UISwitch *autoInviteSwitch;
@end

@implementation CreateMeetingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"创建会议";
    [self initData];
}

- (void)initData {
    self.creatConfParam = [[HWMCreateConfParam alloc] init];
    if ([HWMSdk hasInit]) {
        [[HWMBizSdk getBizOpenApi] getVmrInfoList:^(NSError * _Nullable error, HWMVmrInfoListModel * _Nullable result) {
            if (!error) {
                self.isEnableShareVmr = result.isEnableShareVmr;
                self.vmrList = result.vmrList;
                [self updateVmrInfoView];
            } else {
                [UIUtil showMessageWithError:error];
            }
        }];
    }
}

- (void)setupViews {
    [super setupViews];
    self.scrollView = [[UIScrollView alloc] init];
    [self.view addSubview:self.scrollView];
    [self.scrollView addTapAction:@selector(touchesBegan) target:self];
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.mas_equalTo(0);
        make.width.mas_equalTo(Screen_Width);
    }];
    
    self.subjectTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.subjectTextField];
    self.subjectTextField.placeholder = @"会议主题";
    self.subjectTextField.accessibilityIdentifier = HWMCreatConfSubject;
    [self.subjectTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(50);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.width.mas_equalTo(Screen_Width - 100);
    }];
    [UIView addBottomLineWithView:self.subjectTextField parentView:self.scrollView];
    
    self.customInfoTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.customInfoTextField];
    self.customInfoTextField.placeholder = @"自定义信息";
    self.customInfoTextField.accessibilityIdentifier = HWMCreatConfCustomInfo;
    [self.customInfoTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.subjectTextField.mas_bottom).mas_offset(20);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.width.mas_equalTo(Screen_Width - 100);
    }];
    [UIView addBottomLineWithView:self.customInfoTextField parentView:self.scrollView];
    
    self.concurrentParticipantsTextField = [[HWMUITextField alloc] init];
    [self.scrollView addSubview:self.concurrentParticipantsTextField];
    self.concurrentParticipantsTextField.placeholder = @"会议最大与会人数，默认0";
    self.concurrentParticipantsTextField.accessibilityIdentifier = HWMCreatConfCustomInfo;
    self.concurrentParticipantsTextField.keyboardType = UIKeyboardTypeNumberPad;
    [self.concurrentParticipantsTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.customInfoTextField.mas_bottom).mas_offset(20);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.width.mas_equalTo(Screen_Width - 100);
    }];
    [UIView addBottomLineWithView:self.concurrentParticipantsTextField parentView:self.scrollView];
    
    MediaTypeSwitchView * selectView = [[MediaTypeSwitchView alloc] init];
    selectView.videoBtn.accessibilityIdentifier = HWMCreatConfVideo;
    selectView.audioBtn.accessibilityIdentifier = HWMCreatConfAudio;
    [self.scrollView addSubview:selectView];
    self.isVideoSelect = NO;
    __weak __typeof(self) weakSelf = self;
    selectView.selectBlcok = ^(SelectType type) {
        __strong __typeof(weakSelf) strongSelf = weakSelf;
        strongSelf.isVideoSelect = type;
    };
    [selectView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.concurrentParticipantsTextField.mas_bottom).mas_offset(20);
        make.left.right.mas_equalTo(self.subjectTextField);
        make.height.mas_equalTo(50);
    }];
    self.selectView = selectView;
    
    self.pwdSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.pwdSwitch];
    self.pwdSwitch.selected = NO;
    self.pwdSwitch.accessibilityIdentifier = HWMCreatConfPwdSwitch;
    [self.pwdSwitch addTarget:self action:@selector(pwdSwitchChanged:) forControlEvents:(UIControlEventValueChanged)];
    [self.pwdSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(selectView.mas_bottom).mas_offset(20);
        make.right.mas_equalTo(self.subjectTextField);
    }];
    
    UILabel * pwdLabel = [self newLabelWithTitle:@"是否需要来宾密码"];
    [self.scrollView addSubview:pwdLabel];
    [pwdLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(selectView);
        make.centerY.mas_equalTo(self.pwdSwitch);
    }];
    
    UILabel * attendLabel = [self newLabelWithTitle:@"是否需要携带与会者"];
    [self.scrollView addSubview:attendLabel];
    [attendLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(pwdLabel.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(selectView);
    }];
    
    self.joinSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.joinSwitch];
    self.joinSwitch.selected = NO;
    self.joinSwitch.accessibilityIdentifier = HWMCreatConfJoinMemberSwitch;
    [self.joinSwitch addTarget:self action:@selector(joinSwitchChanged:) forControlEvents:(UIControlEventValueChanged)];
    [self.joinSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(attendLabel);
        make.right.mas_equalTo(self.subjectTextField.mas_right);
    }];
    
    // 允许入会
    UILabel *joinConfRestrictionLabel = [self newLabelWithTitle:@"允许入会"];
    [self.scrollView addSubview:joinConfRestrictionLabel];
    joinConfRestrictionLabel.userInteractionEnabled = YES;
    [joinConfRestrictionLabel addTapAction:@selector(selectJoinConfRestriction:) target:self];
    [joinConfRestrictionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(self.joinSwitch);
        make.top.mas_equalTo(self.joinSwitch.mas_bottom).mas_offset(20);
    }];
    
    self.joinConfRestrictionLabel = [self newLabelWithTitle:@""];
    [self.scrollView addSubview:self.joinConfRestrictionLabel];
    [self updateJoinConfRestrictionLabelText];
    [self.joinConfRestrictionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(self.joinSwitch);
        make.centerY.mas_equalTo(joinConfRestrictionLabel);
    }];
 
    self.cameraSwitch = [self creatLabelAndSwitchWithTopView:self.joinConfRestrictionLabel describe:@"打开摄像头"];
    self.cameraSwitch.accessibilityIdentifier = HWMCreatConfCameraSwitch;
    self.cameraSwitch.on = YES;
    
    self.micSwitch = [self creatLabelAndSwitchWithTopView:self.cameraSwitch describe:@"打开麦克风"];
    self.micSwitch.accessibilityIdentifier = HWMCreatConfMicSwitch;
    self.micSwitch.on = YES;
    
    self.recordSwitch = [self creatLabelAndSwitchWithTopView:self.micSwitch describe:@"打开会议录制"];
    self.recordSwitch.accessibilityIdentifier = HWMCreatConfRecordSwitch;
    self.recordSwitch.on = NO;
    
    self.autoRecordSwitch = [self creatLabelAndSwitchWithTopView:self.recordSwitch describe:@"打开自动录制会议"];
    self.autoRecordSwitch.accessibilityIdentifier = HWMCreatConfAutoRecordSwitch;
    self.autoRecordSwitch.on = NO;

    self.supportWatermarkSwitch = [self creatLabelAndSwitchWithTopView:self.autoRecordSwitch describe:@"是否提供水印"];
    self.supportWatermarkSwitch.accessibilityIdentifier = HWMCreatConfSupportWatermarkSwitch;
    self.supportWatermarkSwitch.on = NO;
    
    self.waitingRoomSwitch = [self creatLabelAndSwitchWithTopView:self.supportWatermarkSwitch describe:@"开启等候室"];
    self.waitingRoomSwitch.on = NO;
    
    UILabel *autoMuteTitleLabel = [self newLabelWithTitle:@"个人客户端入会自动静音"];
    [self.scrollView addSubview:autoMuteTitleLabel];
    autoMuteTitleLabel.userInteractionEnabled = YES;
    [autoMuteTitleLabel addTapAction:@selector(selectAutoMuteMode:) target:self];
    [autoMuteTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(self.waitingRoomSwitch);
        make.top.mas_equalTo(self.waitingRoomSwitch.mas_bottom).mas_offset(20);
    }];
    
    self.autoMuteLabel = [self newLabelWithTitle:@""];
    [self.scrollView addSubview:self.autoMuteLabel];
    [self.autoMuteLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.right.mas_equalTo(autoMuteTitleLabel);
    }];
    
    UILabel *hardTerminalAutoMuteTitleLabel = [self newLabelWithTitle:@"会议室设备入会自动静音"];
    [self.scrollView addSubview:hardTerminalAutoMuteTitleLabel];
    hardTerminalAutoMuteTitleLabel.userInteractionEnabled = YES;
    [hardTerminalAutoMuteTitleLabel addTapAction:@selector(selectHardTerminalAutoMuteMode:) target:self];
    [hardTerminalAutoMuteTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(autoMuteTitleLabel);
        make.top.mas_equalTo(autoMuteTitleLabel.mas_bottom).mas_offset(20);
    }];
    
    self.hardTerminalAutoMuteLabel = [self newLabelWithTitle:@""];
    [self.scrollView addSubview:self.hardTerminalAutoMuteLabel];
    [self.hardTerminalAutoMuteLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.centerY.mas_equalTo(hardTerminalAutoMuteTitleLabel);
    }];
    [self updateAutoMuteLabelText];
    
    self.earpieceSwitch = [self creatLabelAndSwitchWithTopView:self.hardTerminalAutoMuteLabel describe:@"打开听筒"];
    self.earpieceSwitch.on = NO;
    self.earpieceSwitch.accessibilityIdentifier = HWMCreatConfEarpieceSwitch;
    
    self.summarySwitch = [self creatLabelAndSwitchWithTopView:self.earpieceSwitch describe:@"录制时开启会议纪要"];
    self.summarySwitch.on = NO;
    
    self.autoPublishSummarySwitch = [self creatLabelAndSwitchWithTopView:self.summarySwitch describe:@"自动发布会议纪要"];
    self.autoPublishSummarySwitch.on = NO;
    
    self.autoInviteSwitch = [self creatLabelAndSwitchWithTopView:self.autoPublishSummarySwitch describe:@"会议开始自动呼叫与会者"];
    [self.autoInviteSwitch setOn:YES];
    self.autoInviteSwitch.accessibilityIdentifier = HWMManageConfAutoInviteSwitch;
    
    self.vmrIdTypeView = [[UIView alloc] init];
    self.vmrIdTypeView.hidden = YES;
    [self.scrollView addSubview:self.vmrIdTypeView];
    self.vmrIdTypeSwitch = [self creatLabelAndSwitchWithTopView:self.autoInviteSwitch superView:self.vmrIdTypeView describe:@"云会议室是否随机会议id"];
    self.vmrIdTypeSwitch.accessibilityIdentifier = HWMCreatConfVmrIdTypeSwitch;
    [self.vmrIdTypeView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.right.mas_equalTo(self.subjectTextField.mas_right);
        make.top.mas_equalTo(self.autoInviteSwitch.mas_bottom);
        make.bottom.mas_equalTo(self.vmrIdTypeSwitch.mas_bottom);
    }];
    
    self.memberView = [[UITextView alloc] init];
    self.memberView.textColor = HexColor(0x333333);
    self.memberView.font = [UIFont systemFontOfSize:14];
    self.memberView.hidden = YES;
    [self.scrollView addSubview:self.memberView];
    [self.memberView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.autoInviteSwitch.mas_bottom).mas_offset(20);
        make.left.right.mas_equalTo(self.subjectTextField);
        make.height.mas_equalTo(50);
    }];
    
    self.meetingBtn = [UIButton newButtonWithTitle:@"创建会议"];
    self.meetingBtn.accessibilityIdentifier = HWMCreatConfCreat;
    [self.scrollView addSubview:self.meetingBtn];
    [self.meetingBtn addTarget:self action:@selector(creatMeeting) forControlEvents:UIControlEventTouchUpInside];
    [self.meetingBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.vmrIdTypeView.mas_bottom).mas_offset(50);
        make.left.right.mas_equalTo(self.subjectTextField);
        make.height.mas_equalTo(50);
    }];
    
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.meetingBtn.mas_bottom).mas_offset(150);
    }];
    
}

- (void)updateVmrInfoView {
    UIView * topView = self.selectView;
    // 个人会议ID
    if (self.vmrList.count == 1 && !self.isEnableShareVmr) {
        self.personalIDSwitch = [self creatLabelAndSwitchWithTopView:topView describe:[NSString stringWithFormat:@"使用个人会议ID %@", self.vmrList[0].confId]];
        [self.personalIDSwitch setOn:self.creatConfParam.needPassword];
        [self.personalIDSwitch addTarget:self action:@selector(personalIDSwitchChange:) forControlEvents:UIControlEventValueChanged];
        self.personalIDSwitch.accessibilityIdentifier = HWMCreatConfPersonalIDSwitch;
        topView = self.personalIDSwitch;
    } else {
        // 会议ID类型
        UILabel *confIdTypeLabel = [self newLabelWithTitle:@"会议ID类型"];
        confIdTypeLabel.accessibilityIdentifier = HWMCreatConfSelectConfIdType;
        [self.scrollView addSubview:confIdTypeLabel];
        confIdTypeLabel.userInteractionEnabled = YES;
        [confIdTypeLabel addTapAction:@selector(selectConfIdType:) target:self];
        [confIdTypeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(topView);
            make.right.mas_equalTo(self.subjectTextField);
            make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
        }];
        
        self.confIdTypeLabel = [self newLabelWithTitle:@"随机会议ID"];
        [self.scrollView addSubview:self.confIdTypeLabel];
        [self.confIdTypeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(self.subjectTextField);
            make.centerY.mas_equalTo(confIdTypeLabel);
        }];
        topView = confIdTypeLabel;
    }
    
    // 密码输入
    self.pwdTextField = [self creatLabelAndTextFieldWithTopView:topView describe:@"会议密码" placeholder:@"会议密码"];
    self.pwdTextField.accessibilityIdentifier = HWMCreatConfPwdInput;
    self.pwdTextField.keyboardType = UIKeyboardTypeNumberPad;
    topView = self.pwdTextField;
    
    [self.pwdSwitch mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(topView.mas_bottom).offset(20);
        make.right.mas_equalTo(self.subjectTextField);
    }];
}

- (void)pwdSwitchChanged:(UISwitch *)swt {
    self.needPwd = swt.isOn;
}

- (void)joinSwitchChanged:(UISwitch *)swt {
    self.needMembers = swt.isOn;
    self.memberView.hidden = !swt.isOn;
    [self.meetingBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        if(self.needMembers) {
            make.top.mas_equalTo(self.memberView.mas_bottom).mas_offset(50);
        }
        else {
            make.top.mas_equalTo(self.memberView.mas_top).mas_offset(30);
        }
        make.left.right.mas_equalTo(self.subjectTextField);
        make.height.mas_equalTo(50);
    }];
    if (swt.on) {
        __weak __typeof(self) weakSelf = self;
        __block NSMutableArray *numbers = [NSMutableArray array];
        [self.selectedMemebrs enumerateObjectsUsingBlock:^(HWMContactSelectedModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            HWMConfContactModel * model = [[HWMConfContactModel alloc] init];
            model.number = obj.number;
            model.accountId = obj.accountId;
            model.isHardTerminal = obj.isHardTerminal;
            [numbers addObject:model];
        }];
        [[HWMSdk getPrivateApi] openContactSelectPage:numbers scene:HWMSelectedContactCreateConf completeHander:^(NSArray<HWMContactSelectedModel *> * _Nonnull result, NSError * _Nonnull error) {
            NSMutableArray * selectedMemebrs = [NSMutableArray arrayWithArray:self.selectedMemebrs];
            [selectedMemebrs addObjectsFromArray:result];
            weakSelf.selectedMemebrs = selectedMemebrs;
            [weakSelf refreshMemberView];
        }];
    }
    
}

-(void)refreshMemberView{
    __block NSMutableString *memberString = [[NSMutableString alloc] init];
    [self.selectedMemebrs enumerateObjectsUsingBlock:^(HWMContactSelectedModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        [memberString appendFormat:@"%@,", obj.name];
    }];
    self.memberView.text = memberString;
}

- (void)touchesBegan {
    [self endEdit];
}

- (void)endEdit {
    [self.scrollView endEditing:YES];
}

- (HWMVmrIdType)getVmrIDType {
    BOOL isVmrMeetingRoom = self.creatConfParam.vmrId.length > 0 && ![self.creatConfParam.vmrId isEqualToString:self.vmrList[0].vmrId];
    if (isVmrMeetingRoom) {
        return self.vmrIdTypeSwitch.isOn ? HWMVmrIdTypeRandom : HWMVmrIdTypeFixed;
    }
    return HWMVmrIdTypeFixed;
}

- (void)creatMeeting {
    if (![HWMSdk hasInit]) {
        [UIUtil showMessage:@"请先初始化"];
        return;
    }
    self.creatConfParam.subject = self.subjectTextField.text;
    self.creatConfParam.customInfo = self.customInfoTextField.text;
    self.creatConfParam.confType = self.isVideoSelect? HWMConfTypeVideoData:HWMConfTypeAudioAndData;
    self.creatConfParam.needPassword = self.needPwd;
    self.creatConfParam.guestPwd = self.pwdTextField.text;
    self.creatConfParam.isCameraOn = self.cameraSwitch.isOn;
    self.creatConfParam.isMicOn = self.micSwitch.isOn;
    self.creatConfParam.isRecordOn = self.recordSwitch.isOn;
    self.creatConfParam.isAutoRecord = self.autoRecordSwitch.isOn;
    self.creatConfParam.vmrIdType = [self getVmrIDType];
    self.creatConfParam.supportWatermark = self.supportWatermarkSwitch.isOn;
    self.creatConfParam.isOpenWaitingRoom = self.waitingRoomSwitch.isOn;
    self.creatConfParam.isSpeakerOff = self.earpieceSwitch.isOn;
    self.creatConfParam.concurrentParticipants = [self.concurrentParticipantsTextField.text integerValue];
    self.creatConfParam.defaultSummaryState = self.summarySwitch.isOn ? HWMSDKSummaryStateOpen : HWMSDKSummaryStateClose;
    self.creatConfParam.autoPublishSummary = self.autoPublishSummarySwitch.isOn;
    if (self.needMembers && self.selectedMemebrs) {
        BOOL autoInvite = self.autoInviteSwitch.isOn;
        __block NSMutableArray *members = [[NSMutableArray alloc] init];
        [self.selectedMemebrs enumerateObjectsUsingBlock:^(HWMContactSelectedModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            HWMCreateConfMember *member = [[HWMCreateConfMember alloc] init];
            member.accountId = obj.accountId;
            member.number = obj.number;
            member.name = obj.name;
            member.thirdUserId = obj.thirdUserId;
            member.aliasCN = obj.aliasCN;
            member.aliasEN = obj.aliasEN;
            member.extendedField = obj.extendedField;
            member.orgId = obj.orgId;
            member.type = obj.type;
            member.isAutoInvite = autoInvite;
            [members addObject:member];
        }];
        self.creatConfParam.members = members;
    } else {
        self.creatConfParam.members = @[];
    }
    [self showLoading];
    [[HWMSdk getOpenApi] createConf:self.creatConfParam callback:^(NSError * _Nullable error, HWMCreateConfResult * _Nullable result) {
        [self hideLoading];
        if (error) {
            [UIUtil showMessageWithError:error];
        }else{
            NSLog(@"创会成功");
        }
    }];
}

- (void)selectJoinConfRestriction:(UITapGestureRecognizer *)tap {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"允许入会" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.scrollView;
        alertController.popoverPresentationController.sourceRect = tap.view.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    cancelAction.accessibilityIdentifier = HWMCreatConfJoinConfRestrictionCancel;
    
    UIAlertAction *allAction = [UIAlertAction actionWithTitle:@"所有人" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.creatConfParam.joinConfRestrictionType = HWMJoinConfRestrictionAll;
        [self updateJoinConfRestrictionLabelText];
    }];
    allAction.accessibilityIdentifier = HWMCreatConfJoinConfRestrictionAll;
    UIAlertAction *companyAction = [UIAlertAction actionWithTitle:@"仅企业内人员" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.creatConfParam.joinConfRestrictionType = HWMJoinConfRestrictionCompany;
        [self updateJoinConfRestrictionLabelText];
    }];
    companyAction.accessibilityIdentifier = HWMCreatConfJoinConfRestrictionCompany;
    UIAlertAction *invitedAction = [UIAlertAction actionWithTitle:@"仅会议邀请人员" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.creatConfParam.joinConfRestrictionType = HWMJoinConfRestrictionInvited;
        [self updateJoinConfRestrictionLabelText];
    }];
    invitedAction.accessibilityIdentifier = HWMCreatConfJoinConfRestrictionInvited;
    [alertController addAction:cancelAction];
    [alertController addAction:allAction];
    [alertController addAction:companyAction];
    [alertController addAction:invitedAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)updateJoinConfRestrictionLabelText {
    self.joinConfRestrictionLabel.text = [self getTitleAllowInComming:self.creatConfParam.joinConfRestrictionType];
}

- (NSString *)getTitleAllowInComming:(HWMJoinConfRestrictionType)callInRestrictionType
{
    switch (callInRestrictionType) {
        case HWMJoinConfRestrictionAll:
            return @"所有人";
            break;
        case HWMJoinConfRestrictionCompany:
            return @"仅企业内人员";
            break;
        case HWMJoinConfRestrictionInvited:
            return @"仅会议邀请人员";
            break;
        default:
            return @"";
            break;
    }
}

- (void)selectAutoMuteMode:(UITapGestureRecognizer *)tap {
   [self handleSelectAutoMuteMode:tap handler:^(HWMAutoMuteType type) {
       self.creatConfParam.autoMuteMode = type;
       [self updateAutoMuteLabelText];
   }];
}

- (void)selectHardTerminalAutoMuteMode:(UITapGestureRecognizer *)tap {
   [self handleSelectAutoMuteMode:tap handler:^(HWMAutoMuteType type) {
       self.creatConfParam.hardTerminalAutoMuteMode = type;
       [self updateAutoMuteLabelText];
   }];
}

- (void)handleSelectAutoMuteMode:(UITapGestureRecognizer *)tap handler:(void(^)(HWMAutoMuteType type))handler {
   UIAlertController *alertController = [CommonUtil createAutoMuteAlertController:handler];
   if (Is_Ipad) {
       alertController.popoverPresentationController.sourceView = self.scrollView;
       alertController.popoverPresentationController.sourceRect = tap.view.frame;
   }
   [self presentViewController:alertController animated:YES completion:nil];
}

- (void)updateAutoMuteLabelText {
   self.autoMuteLabel.text = [CommonUtil getTitleAutoMute:self.creatConfParam.autoMuteMode];
   self.hardTerminalAutoMuteLabel.text = [CommonUtil getTitleAutoMute:self.creatConfParam.hardTerminalAutoMuteMode];
}

- (void)personalIDSwitchChange:(UISwitch *)swt {
    HWMVmrInfoModel * model = self.vmrList[0];
    [self.pwdTextField setEnabled:!swt.isOn];
    [self updatePwdTextFeild:swt.isOn ? self.vmrList[0].guestPwd : @""];
    self.creatConfParam.vmrId = swt.isOn ? model.vmrId : @"";
    if (swt.isOn) {
        [self updateCallInRestrictionAndWaitingRoom:self.vmrList[0]];
    }
}

- (void)updateCallInRestrictionAndWaitingRoom:(HWMVmrInfoModel *)vmrInfo {
    self.creatConfParam.joinConfRestrictionType = (HWMJoinConfRestrictionType)vmrInfo.confAllowJoinUser;
    [self updateJoinConfRestrictionLabelText];
    self.creatConfParam.isOpenWaitingRoom = vmrInfo.isOpenWaitingRoom;
    [self.waitingRoomSwitch setOn:vmrInfo.isOpenWaitingRoom animated:YES];
}

- (void)selectConfIdType:(UITapGestureRecognizer *)tap {
    if (self.vmrList.count == 1 && !self.isEnableShareVmr) {
        return;
    }
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"会议类型" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.scrollView;
        alertController.popoverPresentationController.sourceRect = tap.view.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    cancelAction.accessibilityIdentifier = HWMCreatConfSelectConfIdTypeCancel;
    [alertController addAction:cancelAction];
    
    [self.vmrList enumerateObjectsUsingBlock:^(HWMVmrInfoModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        UIAlertAction *action;
        if (idx == 0) {
            NSString * title = @"个人会议ID";
            action = [UIAlertAction actionWithTitle:title style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                [self changeVmrIdTypeViewHidden:YES];
                [self updateConfIdTypeLabelText:title confPwd:obj.guestPwd vmrId:obj.vmrId];
                [self updateCallInRestrictionAndWaitingRoom:obj];
            }];
            action.accessibilityIdentifier = HWMCreatConfSelectConfIdTypePerson;
        } else {
            NSString * title = [NSString stringWithFormat:@"%@(%zd)%@", obj.name, obj.maxParties, obj.confId];
            action = [UIAlertAction actionWithTitle:title style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                [self changeVmrIdTypeViewHidden:NO];
                [self updateConfIdTypeLabelText:title confPwd:obj.guestPwd vmrId:obj.vmrId];
                [self updateCallInRestrictionAndWaitingRoom:obj];
            }];
            action.accessibilityIdentifier = [NSString stringWithFormat:@"%@%zd", HWMCreatConfSelectConfIdTypePerson, idx];
        }
        [alertController addAction:action];
    }];
    
    NSString * title = @"随机会议ID";
    UIAlertAction *action = [UIAlertAction actionWithTitle:title style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self changeVmrIdTypeViewHidden:YES];
        [self updateConfIdTypeLabelText:title confPwd:@"" vmrId:@""];
    }];
    [alertController addAction:action];
    action.accessibilityIdentifier = HWMCreatConfSelectConfIdTypeRandom;
    if (self.isEnableShareVmr) {
        UIAlertAction *action = [UIAlertAction actionWithTitle:@"共享云会议室" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            [self changeVmrIdTypeViewHidden:YES];
            [self updateConfIdTypeLabelText:@"共享云会议室" confPwd:@"" vmrId:@""];
            self.creatConfParam.confResType = HWMSDKConfRestypeShareVmr;
            self.creatConfParam.vmrIdType = HWMVmrIdTypeRandom;
        }];
        action.accessibilityIdentifier = HWMCreatConfSelectConfIdTypeShareVmr;
        [alertController addAction:action];
    }
    [self presentViewController:alertController animated:YES completion:nil];
}
- (void)changeVmrIdTypeViewHidden:(BOOL)hidden {
    self.vmrIdTypeView.hidden = hidden;
}
- (void)updateConfIdTypeLabelText:(NSString *)text confPwd:(NSString *)pwd vmrId:(NSString *)vmrId {
    self.confIdTypeLabel.text = text;
    [self updatePwdTextFeild:pwd];
    self.creatConfParam.vmrId = vmrId;
}

- (void)updatePwdTextFeild:(NSString *)pwd {
    self.pwdTextField.text = pwd;
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel * label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

- (UISwitch *)creatLabelAndSwitchWithTopView:(UIView *)topView describe:(NSString *)describe {
    return [self creatLabelAndSwitchWithTopView:topView superView:self.scrollView describe:describe];
}

- (UISwitch *)creatLabelAndSwitchWithTopView:(UIView *)topView superView:(UIView *)superView describe:(NSString *)describe {
    UILabel *describeLabel = [self newLabelWithTitle:describe];
    [superView addSubview:describeLabel];
    [describeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(50);
    }];
    
    UISwitch *swt = [[UISwitch alloc] init];
    [superView addSubview:swt];
    [swt mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(describeLabel);
        make.right.mas_equalTo(self.subjectTextField);
    }];
    return swt;
}

- (HWMUITextField *)creatLabelAndTextFieldWithTopView:(UIView *)topView describe:(NSString *)describe placeholder:(NSString *)placeholder {
    UILabel *describeLabel = [self newLabelWithTitle:describe];
    [self.scrollView addSubview:describeLabel];
    [describeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        if (topView) {
            make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
        } else {
            make.top.mas_equalTo(100);
        }
        make.left.mas_equalTo(50);
        make.height.mas_equalTo(30);
        make.width.mas_equalTo(70);
    }];
    
    HWMUITextField *textField = [[HWMUITextField alloc] init];
    [self.scrollView addSubview:textField];
    textField.placeholder = placeholder;
    [textField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(describeLabel);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(describeLabel.mas_right).mas_offset(20);
        make.width.mas_equalTo(Screen_Width - 50 - 140);
    }];
    [UIView addBottomLineWithView:textField parentView:self.scrollView];
    return textField;
}

@end
