//
//  CustomVirtualBakcgroundImpl.m
//  HWMSDKDemo
//
//  Created by lining on 2024/10/26.
//  Copyright © 2024 HuaWei. All rights reserved.
//

#import "CustomVirtualBakcgroundImpl.h"
#import "UIUtil.h"

@interface CustomVirtualBakcgroundImpl () <UIImagePickerControllerDelegate, UINavigationControllerDelegate>

@property (nonatomic, copy) void (^callback)(HWMVirtualBackgroundImageModel *model);

@end

@implementation CustomVirtualBakcgroundImpl

- (void)onClickAddVirtualBackgroundItem:(void (^)(HWMVirtualBackgroundImageModel * _Nonnull))callback {
    self.callback = callback;
    UIImagePickerController *picker = [[UIImagePickerController alloc] init];
    picker.delegate = self;
    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    [[UIUtil findCurrentViewController] presentViewController:picker animated:YES completion:nil];
}

#pragma mark - UIImagePickerControllerDelegate
- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    self.callback = nil;
    [picker dismissViewControllerAnimated:YES completion:nil];
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<UIImagePickerControllerInfoKey, id> *)info {
    [picker dismissViewControllerAnimated:YES completion:^{
        if (self.callback) {
            NSURL *imageUrl = info[UIImagePickerControllerImageURL];
            HWMVirtualBackgroundImageModel *model = [[HWMVirtualBackgroundImageModel alloc] init];
            model.imagePath = imageUrl.path;
            self.callback(model);
            self.callback = nil;
        }
    }];
}

@end
