//
//  HWMConfMenuHandlerImpl.m
//  HWMConfUI
//
//  Created by y00450113 on 2020/5/9.
//  Copyright © 2020 huawei. All rights reserved.
//

#import "AudioConfMenuHandlerImpl.h"
#import "HWMConfMenuListItem.h"
#import "HWMConfSettingGroup.h"

@implementation AudioConfMenuHandlerImpl

/// 构建音频会议底部toolbar的会控全量菜单
- (NSArray <HWMConfToolBarMenuItem *> *)buildToolBarMenuItems {
    // 麦克风 静音 or取消静音
    HWMConfToolBarMenuItem *micItem = [HWMConfToolBarMenuItem defaultMicItem];
    // 扬声器 听筒 切换
    HWMConfToolBarMenuItem *loadspeakerItem = [HWMConfToolBarMenuItem defaultLoudSpeakItem];
    // 屏幕共享
    HWMConfToolBarMenuItem *screenShareItem = [HWMConfToolBarMenuItem defaultScreenShareItem];
    // 与会者列表
    HWMConfToolBarMenuItem *attendeeItem = [HWMConfToolBarMenuItem defaultAttendeeItem];
    // 更多
    HWMConfToolBarMenuItem *moreItem = [HWMConfToolBarMenuItem defaultMoreItem];
    return @[micItem, loadspeakerItem, screenShareItem, attendeeItem, moreItem];
}

/// 构建音频会议底部toolbar的“更多”菜单
- (NSArray <HWMConfMenuListItem *> *)buildToolBarMoreMenuItems {
    // 聊天
    HWMConfMenuListItem *chatItem = [HWMConfMenuListItem defaultChatItem];
    // 传译
    HWMConfMenuListItem *interpretItem = [HWMConfMenuListItem defaultInterpretItem];
    // 邀请
    HWMConfMenuListItem *inviteItem = [HWMConfMenuListItem defaultInviteItem];
    //录制
    HWMConfMenuListItem *recordItem = [HWMConfMenuListItem defaultRecordItem];
    //直播
    HWMConfMenuListItem *liveBraodcastItem = [HWMConfMenuListItem defaultLiveBroadcastItem];
    // 举手
    HWMConfMenuListItem *raiseHandsItem = [HWMConfMenuListItem defaultRaiseHandsItem];
    // 投票
    HWMConfMenuListItem *voteItem = [HWMConfMenuListItem defaultVoteItem];
    // 设置
    HWMConfMenuListItem *settingItem = [HWMConfMenuListItem defaultSettingItem];
    
    return @[chatItem, interpretItem, inviteItem, recordItem, liveBraodcastItem, raiseHandsItem, voteItem, settingItem];
}

// 构建点击更多菜单的设置弹出的设置列表项目
- (NSArray <HWMConfSettingGroup *> *)buildSettingItems {
    HWMConfSettingGroup *audioVideoGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"音视频"];
    HWMConfSettingItem *howlItem = [HWMConfSettingItem defaultHowlDetection];
    HWMConfSettingItem *hideFloatMicroButtonItem = [HWMConfSettingItem defaultHideFloatMicroButtonItem];
    audioVideoGroup.items = @[howlItem, hideFloatMicroButtonItem];

    HWMConfSettingGroup *securityGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"入会控制"];
    HWMConfSettingItem *lockItem = [HWMConfSettingItem defaultLockItem];
    HWMConfSettingItem *allowJoinConfItem = [HWMConfSettingItem defaultAllowJoinConf];
    HWMConfSettingItem *waitingRoomItem = [HWMConfSettingItem defaultWaitingRoom];
    HWMConfSettingItem *autoMuteItem = [HWMConfSettingItem defaultAutoMuteItem];
    securityGroup.items = @[lockItem, allowJoinConfItem, waitingRoomItem, autoMuteItem];
    
    HWMConfSettingGroup *infoSecurityGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"信息安全"];
    HWMConfSettingItem *watermarkItem = [HWMConfSettingItem defaultWatermarkItem];
    infoSecurityGroup.items = @[watermarkItem];

    HWMConfSettingGroup *authorityGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"与会者权限"];
    HWMConfSettingItem *allowUnmuteItem = [HWMConfSettingItem defaultAllowAttendeeUnmuteItem];
    HWMConfSettingItem *allowAttendeeAnnotate = [HWMConfSettingItem defaultAllowAttendeeAnnotate];
    HWMConfSettingItem *shareLockItem = [HWMConfSettingItem defaultLockShareItem];
    HWMConfSettingItem *preemptSharePermissionItem = [HWMConfSettingItem defaultPreemptSharePermissionItem];
    HWMConfSettingItem *chatItem = [HWMConfSettingItem defaultAllowChat];
    HWMConfSettingItem *localRecordRightsItem = [HWMConfSettingItem defaultLocalRecordRights];
    HWMConfSettingItem *allowRenameItem = [HWMConfSettingItem defaultAllowRenameItem];
    authorityGroup.items = @[allowUnmuteItem, allowAttendeeAnnotate, shareLockItem, preemptSharePermissionItem, chatItem, allowRenameItem, localRecordRightsItem];

    HWMConfSettingGroup *commonGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"通用"];
    HWMConfSettingItem *networkDetectItem = [HWMConfSettingItem defaultNetworkDetectItem];
    HWMConfSettingItem *feedbackItem = [HWMConfSettingItem defaultFeedbackItem];
    HWMConfSettingItem *chatRemindItem = [HWMConfSettingItem defaultChatRemindItem];
    commonGroup.items = @[chatRemindItem,networkDetectItem, feedbackItem];
    
    return @[audioVideoGroup, securityGroup, infoSecurityGroup, authorityGroup, commonGroup];
}
@end
