//
//  ParticipantListMenuHandlerImpl.m
//  HWMConfUI
//
//  Created by y00450113 on 2020/7/7.
//  Copyright © 2020 huawei. All rights reserved.
//

#import "ParticipantListMenuHandlerImpl.h"

@implementation ParticipantListMenuHandlerImpl

/// 构建与会者列表底部toolbar上的菜单
- (NSArray <HWMConfToolBarMenuItem *> *)buildParticipantToolBarMenuItems {
    // 全场静音
    HWMConfToolBarMenuItem *muteAllItem = [HWMConfToolBarMenuItem defaultMuteAllItem];
    // 解除全场静音
    HWMConfToolBarMenuItem *unmuteAllItem = [HWMConfToolBarMenuItem defaultUnmuteAllItem];
    // 更多
    HWMConfToolBarMenuItem *moreItem = [HWMConfToolBarMenuItem defaultMemberListMoreItem];
    // 举手
    HWMConfToolBarMenuItem *handupItem = [HWMConfToolBarMenuItem defaultHandupItem];
    // 请求主持人
    HWMConfToolBarMenuItem *requestChairmanItem = [HWMConfToolBarMenuItem defaultRequestChairmanItem];
    return @[muteAllItem, unmuteAllItem, moreItem, handupItem, requestChairmanItem];
}

/// 构建等候中列表底部toolbar上的菜单
- (NSArray<HWMConfToolBarMenuItem *> *)buildWaitingToolBarMenuItems {
    // 全体准入
    HWMConfToolBarMenuItem *admitAllItem = [HWMConfToolBarMenuItem defaultAdmitAllItem];
    // 全部移除
    HWMConfToolBarMenuItem *removeAllItem = [HWMConfToolBarMenuItem defaultRemoveAllItem];
    return @[admitAllItem, removeAllItem];
}

/// 构建未入会列表底部toolbar上的菜单
- (NSArray <HWMConfToolBarMenuItem *> *)buildOfflineToolBarMenuItems {
    // 全部呼叫
    HWMConfToolBarMenuItem *recallAllItem = [HWMConfToolBarMenuItem defaultRecallAllItem];
    return @[recallAllItem];
}

/// 构建与会者列表底部toolbar上的“更多”菜单
- (NSArray <HWMConfMenuItem *> *)buildParticipantToolBarMoreMenuItems {
    // 释放支持人
    HWMConfMenuItem *releaseChairmanItem = [HWMConfMenuItem defaultReleaseChairmanItem];
    // 申请主持人
    HWMConfMenuItem *requestChairmanItem = [HWMConfMenuItem defaultRequestChairmanItem];
    // 锁定会议
    HWMConfMenuItem *lockItem = [HWMConfMenuItem defaultLockItem];
    // 允许 or 禁止 与会者自己解除静音
    HWMConfMenuItem *allowUnmuteItem = [HWMConfMenuItem defaultAllowAttendeeUnmuteItem];
    return @[requestChairmanItem,releaseChairmanItem,allowUnmuteItem,lockItem];
}

/// 构建与会者列表右上角的菜单
- (NSArray <HWMConfToolBarMenuItem *> *)buildParticipantTitleBarMenuItems {
    HWMConfToolBarMenuItem *shareItem = [HWMConfToolBarMenuItem defaultShareItem];
     HWMConfToolBarMenuItem *addressBookItem = [HWMConfToolBarMenuItem defaultAddressBookItem];
     return @[shareItem, addressBookItem];
}


/// 构建与会者列表中成员点击弹出的actionsheet的菜单
- (NSArray <HWMConfParticipantActionMenuItem *> *)buildParticipantActionSheetItems {
    /// 静音 or 取消静音
    HWMConfParticipantActionMenuItem *muteItem = [HWMConfParticipantActionMenuItem defaultMuteItem];
    /// 开启 or 关闭音频
    HWMConfParticipantActionMenuItem *videoItem = [HWMConfParticipantActionMenuItem defaultVideoItem];
    /// 允许说话
    HWMConfParticipantActionMenuItem *allowedSpeakItem = [HWMConfParticipantActionMenuItem defaultAllowedSpeakItem];
    /// 举手 or 手放下
    HWMConfParticipantActionMenuItem *handupItem = [HWMConfParticipantActionMenuItem defaultHandupItem];
    /// 选看 or 取消选看
    HWMConfParticipantActionMenuItem *watchItem = [HWMConfParticipantActionMenuItem defaultWatchItem];
    /// 广播会场 or 停止
    HWMConfParticipantActionMenuItem *broadcastItem = [HWMConfParticipantActionMenuItem defaultBroadcastItem];
    /// 重呼
    HWMConfParticipantActionMenuItem *recallItem = [HWMConfParticipantActionMenuItem defaultRecallItem];
    
    /// 改名
    HWMConfParticipantActionMenuItem *changeNameItem = [HWMConfParticipantActionMenuItem defaultChangeNickNameItem];
    // 授权或取消本地录制权限
    HWMConfParticipantActionMenuItem *allowLocalRecordItem = [HWMConfParticipantActionMenuItem defaultAllowLocalRecordItem];
    /// 邀请/取消共享（仅主持人或联席主持人有该权限，用户是硬终端、pstn、老版本入会、点对点呼叫，不支持邀请/取消共享）
    HWMConfParticipantActionMenuItem *inviteScreenShareItem = [HWMConfParticipantActionMenuItem defaultInviteScreenShareItem];
    /// 请求主持人
    HWMConfParticipantActionMenuItem *requestChairmanItem = [HWMConfParticipantActionMenuItem defaultRequestChairmanItem];
    /// 转移主持人
    HWMConfParticipantActionMenuItem *transferItem = [HWMConfParticipantActionMenuItem defaultTransferChairmanItem];
    /// 释放主持人
    HWMConfParticipantActionMenuItem *releaseChairmanItem = [HWMConfParticipantActionMenuItem defaultReleaseChairmanItem];
    /// 呼叫其他号码
    HWMConfParticipantActionMenuItem *callOtherItem = [HWMConfParticipantActionMenuItem defaultCallOtherNumberItem];
    /// 设置为观众/嘉宾
    HWMConfParticipantActionMenuItem *switchAudienceAndAttendeeItem = [HWMConfParticipantActionMenuItem defaultSwitchAudienceAndAttendeeItem];
    
    /// 挂断
    HWMConfParticipantActionMenuItem *hangupItem = [HWMConfParticipantActionMenuItem defaultHangupItem];
    /// 移除与会者
    HWMConfParticipantActionMenuItem *removeAttendeeItem = [HWMConfParticipantActionMenuItem defaultRemoveAttendeeItem];

    // 设为/撤销联席主持人（用户是主持人、硬终端、观众、pstn、老版本入会，不支持被设为联席）
    HWMConfParticipantActionMenuItem *coHostItem = [HWMConfParticipantActionMenuItem defaultCoHost];
    
    // 移至等候室
    HWMConfParticipantActionMenuItem *moveToWaitingRoomItem = [HWMConfParticipantActionMenuItem defaultMoveToWaitingRoom];
    // 准入
    HWMConfParticipantActionMenuItem *admitItem = [HWMConfParticipantActionMenuItem defaultAdmitWaitingRoomParticipant];
    // 移除
    HWMConfParticipantActionMenuItem *removeWaitingRoomParticipantItem = [HWMConfParticipantActionMenuItem defaultRemoveWaitingRoomParticipant];
    
    /// 私聊
    HWMConfParticipantActionMenuItem *privateChatItem = [HWMConfParticipantActionMenuItem defaultPrivateChatItem];
    
    return @[muteItem, videoItem, handupItem, watchItem, privateChatItem, broadcastItem, recallItem,
             changeNameItem, allowedSpeakItem, allowLocalRecordItem, inviteScreenShareItem, switchAudienceAndAttendeeItem, requestChairmanItem, transferItem, releaseChairmanItem, coHostItem, moveToWaitingRoomItem, admitItem, removeWaitingRoomParticipantItem, callOtherItem,
             hangupItem, removeAttendeeItem];
}

@end
