//
//  SetAvatarStyleViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/3/31.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "SetAvatarStyleViewController.h"
#import <HWMUISDK/HWMBizSdk.h>

@interface SetAvatarStyleViewController () <UIImagePickerControllerDelegate, UINavigationControllerDelegate>
@property (weak, nonatomic) IBOutlet UITextField *backgroundColorTF;
@property (weak, nonatomic) IBOutlet UITextField *textColorTF;
@property (nonatomic, assign) HWMNameShowType nameShowType;
@property (weak, nonatomic) IBOutlet UIButton *nameShowTypeButton;
@property (weak, nonatomic) IBOutlet UIImageView *phoneIconView;
@property (weak, nonatomic) IBOutlet UIImageView *boardIconView;
@property (nonatomic, assign) BOOL isSelectPhoneIcon;

@end

@implementation SetAvatarStyleViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"设置默认头像风格";
}

- (IBAction)onNameShowTypeButtonClick:(UIButton *)sender {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"姓名显示风格" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.view;
        alertController.popoverPresentationController.sourceRect = sender.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    UIAlertAction *cloudModeAction = [UIAlertAction actionWithTitle:@"显示拼音首字母" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.nameShowType = HWMNameShowTypeFirstName;
        [self.nameShowTypeButton setTitle:@"显示拼音首字母" forState:UIControlStateNormal];
    }];
    UIAlertAction *sinkModeAction = [UIAlertAction actionWithTitle:@"显示姓氏" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.nameShowType = HWMNameShowTypeFamilyName;
        [self.nameShowTypeButton setTitle:@"显示姓氏" forState:UIControlStateNormal];
    }];
    [alertController addAction:cancelAction];
    [alertController addAction:cloudModeAction];
    [alertController addAction:sinkModeAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (IBAction)setting {
    HWMAvatarStyle *style = [[HWMAvatarStyle alloc] init];
    style.backgroundColor = [self convertRGBStringToColor:self.backgroundColorTF.text];
    style.textColor = [self convertRGBStringToColor:self.textColorTF.text];
    style.nameShowType = self.nameShowType;
    style.avatarShape = HWMAvatarShapeCircle;
    style.phoneIcon = self.phoneIconView.image;
    style.boardIcon = self.boardIconView.image;
    HWMSDKERR ret = [[HWMBizSdk getBizOpenApi] setParticipantAvatarStyle:style];
    if (ret == HWMSDKSdkerrSuccess) {
        [UIUtil showMessage:@"设置成功"];
    } else {
        [UIUtil showMessage:@"设置失败"];
    }
}

- (UIColor *)convertRGBStringToColor:(NSString *)str {
    if (str.length != 6) {
        return nil;
    }
    NSRange range = NSMakeRange(0, 2);
    NSString *rStr = [str substringWithRange:range];
    range.location += 2;
    NSString *gStr = [str substringWithRange:range];
    range.location += 2;
    NSString *bStr = [str substringWithRange:range];
    
    unsigned r, g, b = 0;
    [[NSScanner scannerWithString:rStr] scanHexInt:&r];
    [[NSScanner scannerWithString:gStr] scanHexInt:&g];
    [[NSScanner scannerWithString:bStr] scanHexInt:&b];
    return [UIColor colorWithRed: r/255.0 green: g/255.0 blue: b/255.0 alpha: 1.0];
}

- (IBAction)selectIconButtonClick:(UIButton *)sender {
    self.isSelectPhoneIcon = sender.tag == 0;
    UIImagePickerController *picker = [[UIImagePickerController alloc] init];
    picker.delegate = self;
    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    [self presentViewController:picker animated:YES completion:nil];
}

#pragma mark - UIImagePickerControllerDelegate
- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    [picker dismissViewControllerAnimated:YES completion:nil];
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<UIImagePickerControllerInfoKey, id> *)info;
{
    [picker dismissViewControllerAnimated:YES completion:^{
        UIImage *image = info[UIImagePickerControllerOriginalImage];
        if (self.isSelectPhoneIcon) {
            self.phoneIconView.image = image;
        } else {
            self.boardIconView.image = image;
        }
    }];
}

@end
