//
//  SetExtensionBundleIdViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2024/3/1.
//  Copyright © 2024 HuaWei. All rights reserved.
//

#import "SetExtensionBundleIdViewController.h"

@interface SetExtensionBundleIdViewController ()

/// 屏幕共享extension bundleId
@property (nonatomic, strong) UITextField *screenShareExtensionBundleIdTF;

@end

@implementation SetExtensionBundleIdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"设置Extension BundleId";
}

- (void)setupViews {
    [super setupViews];
    UILabel *contentLabel = [[UILabel alloc] init];
    contentLabel.text = @"注意事项:先初始化后设置Extension BundleId";
    
    self.screenShareExtensionBundleIdTF = [[UITextField alloc] init];
    self.screenShareExtensionBundleIdTF.placeholder = @"请输入屏幕共享Extension BundleId";
    self.screenShareExtensionBundleIdTF.backgroundColor = HexColor(0xf2f2f2);
    
    UIButton *setScreenShareExtensionBundleIdBtn = [UIButton newButtonWithTitle:@"设置屏幕共享Extension BundleId"];
    [setScreenShareExtensionBundleIdBtn addTarget:self action:@selector(setScreenShareExtensionBundleId) forControlEvents:UIControlEventTouchUpInside];

    UIStackView *stackView = [[UIStackView alloc] init];
    stackView.spacing = 10.0;
    stackView.axis = UILayoutConstraintAxisVertical;
    stackView.distribution = UIStackViewDistributionFillEqually;

    [stackView addArrangedSubview:contentLabel];
    [stackView addArrangedSubview:self.screenShareExtensionBundleIdTF];
    [stackView addArrangedSubview:setScreenShareExtensionBundleIdBtn];

    [self.view addSubview:stackView];
    [stackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.view).mas_offset(150);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
        make.height.mas_equalTo(250);
    }];
}

- (void)setScreenShareExtensionBundleId {
    NSString *screenShareExtensionBundleId = self.screenShareExtensionBundleIdTF.text;
    [HWMSdk setScreenShareExtensionBundleId:screenShareExtensionBundleId];
    [UIUtil showMessage:[NSString stringWithFormat:@"screenShareExtensionBundleId:%@", screenShareExtensionBundleId]];
}

@end
