//
//  SetGuaranteeIpAddrsViewController.m
//  HWMSDKDemo
//
//  Created by 204053 on 2023/10/28.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import "SetGuaranteeIpAddrsViewController.h"
#import <HWMUISDK/HWMBizSdk.h>

@interface SetGuaranteeIpAddrsViewController ()
@property (nonatomic, strong) UITextField *guaranteeIpAddrsTextField;      /**< 保底IP输入框 */
@end

@implementation SetGuaranteeIpAddrsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"设置(会控)保底IP";
}

- (void)setupViews {
    [super setupViews];
    UILabel *contentLabel = [[UILabel alloc] init];
    contentLabel.text = @"保底IP:用分号隔开, 最多支持4个地址";
    
    self.guaranteeIpAddrsTextField = [[UITextField alloc] init];
    self.guaranteeIpAddrsTextField.placeholder = @"请输入(会控)保底IP";
    self.guaranteeIpAddrsTextField.backgroundColor = HexColor(0xf2f2f2);
    
    UIButton *setGuaranteeIpAddrsBtn = [UIButton newButtonWithTitle:@"设置(会控)保底IP"];
    [setGuaranteeIpAddrsBtn addTarget:self action:@selector(handelSetGuaranteeIpAddrs) forControlEvents:UIControlEventTouchUpInside];
    
    UIStackView *stackView = [[UIStackView alloc] init];
    stackView.spacing = 10.0;
    stackView.axis = UILayoutConstraintAxisVertical;
    stackView.distribution = UIStackViewDistributionFillEqually;

    [stackView addArrangedSubview:contentLabel];
    [stackView addArrangedSubview:self.guaranteeIpAddrsTextField];
    [stackView addArrangedSubview:setGuaranteeIpAddrsBtn];
    [self.view addSubview:stackView];
    [stackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.view).mas_offset(150);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
        make.height.mas_equalTo(150);
    }];
}

/// 设置保底IP
- (void)handelSetGuaranteeIpAddrs {
    HWMSDKERR result = [[HWMBizSdk getBizOpenApi] setGuaranteedIpAddresses:self.guaranteeIpAddrsTextField.text];
    NSString *tip = @"设置成功";
    if (result != HWMSDKSdkerrSuccess) {
        tip = [NSString stringWithFormat:@"设置失败[%ld]",result];
    }
    [UIUtil showMessage:tip];
}

@end
