//
//  InitSDKViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2021/12/22.
//  Copyright © 2021 HuaWei. All rights reserved.
//

#import "InitSDKViewController.h"
#import "SDKEnvConfig.h"
#import "NotifyMessageHandler.h"
#import "GlobalHandlerImpl.h"

@interface InitSDKViewController ()
@property (weak, nonatomic) IBOutlet UITextField *logKeepDaysTextField;
@property (weak, nonatomic) IBOutlet UISwitch *localNotificationSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *multiAppLoginSwitch;
@property (weak, nonatomic) IBOutlet UIButton *sdkBtn;
@property (weak, nonatomic) IBOutlet UIButton *asyncSdkBtn;

@end

@implementation InitSDKViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupViews];
}

- (void)setupViews {
    [self.sdkBtn setDefaultButton];
    [self.sdkBtn setTitle:@"初始化SDK" forState:UIControlStateNormal];
    self.logKeepDaysTextField.accessibilityIdentifier = HWMInitSDKLogKeepDays;
    self.sdkBtn.accessibilityIdentifier = HWMInitSDKInit;
    [self.asyncSdkBtn setDefaultButton];
    [self.asyncSdkBtn setTitle:@"异步初始化SDK" forState:UIControlStateNormal];
    self.asyncSdkBtn.accessibilityIdentifier = HWMInitSDKAsyncInit;
}

- (HWMOpenSDKConfig *)getConfig {
    HWMOpenSDKConfig *config = [[HWMOpenSDKConfig alloc] init];
    /// APPID 接入方式时，config.appId 传入申请到的企业APPID；非APPID接入方式推荐传入企业名称
    config.appId = [SDKEnvConfig sharedInstance].appId ? : @"HWMSDKDemo";
    config.siteType = [SDKEnvConfig sharedInstance].isChinaSite ? HWMSdkSiteTypeChina : HWMSdkSiteTypeAP;
    config.enableTransferHostLeaveConf = YES;
    config.logKeepDays = [self.logKeepDaysTextField.text integerValue];
    config.disableIncomingLocalNotification = self.localNotificationSwitch.isOn;
    [config enableFeature:HWMFeatureTypeRecoedAlert isEnable:[SDKEnvConfig sharedInstance].isShowRecordSafeAlert];
    [config enableFeature:HWMFeatureTypeSaveNickNameWhenAnonymousJoin isEnable:[SDKEnvConfig sharedInstance].isSaveNickNameWhenAnonymousJoin];
    config.isSupportMultiAppLogin = self.multiAppLoginSwitch.isOn;
    [config enableFeature:HWMFeatureTypeSupportDisconnectAudio isEnable:[SDKEnvConfig sharedInstance].supportDisconnectAudio]; // 是否支持断开音频
    [config enableFeature:HWMFeatureTypeBreakoutConf isEnable:[SDKEnvConfig sharedInstance].supportBreakoutConf];
    [config enableFeature:HWMFeatureTypeSupportVirtualBackground isEnable:[SDKEnvConfig sharedInstance].supportVirtualBackground];
    [config enableFeature:HWMFeatureTypeHideInviteResultToast isEnable:[SDKEnvConfig sharedInstance].hideInviteResultToast];
    [config enableFeature:HWMFeatureTypeHiddenVBRiskTip isEnable:[SDKEnvConfig sharedInstance].isHiddenVBRiskTip];
    [config enableFeature:HWMFeatureTypeConfEndHideTips isEnable:[SDKEnvConfig sharedInstance].hideConfEndTips];
    // 如不需要代理可以不写
    config.globalHandler = [NotifyMessageHandler sharedInstance];
    config.bizNotifyHandler = [NotifyMessageHandler sharedInstance];
    config.socialShareHandler = [SDKEnvConfig sharedInstance].customSocialShare ? [GlobalHandlerImpl sharedInstance] : nil;
    config.contactUIHandler = [SDKEnvConfig sharedInstance].customContact ? [GlobalHandlerImpl sharedInstance] : nil;
    config.confUIHandler = [NotifyMessageHandler sharedInstance];
    config.virtualBackgroundHandler = [SDKEnvConfig sharedInstance].customVirtualBackground ? [GlobalHandlerImpl sharedInstance].defaultVirtualBackgroundImpl : nil;
    config.customUITextHandler = [SDKEnvConfig sharedInstance].customText ? [GlobalHandlerImpl sharedInstance] : nil;
    config.customImageHandler = [SDKEnvConfig sharedInstance].customImage ? [GlobalHandlerImpl sharedInstance] : nil;
    config.shareInterceptHandler = [SDKEnvConfig sharedInstance].interceptShare ? [GlobalHandlerImpl sharedInstance] : nil;
    config.logPath = [SDKEnvConfig sharedInstance].logPath;
    if ([SDKEnvConfig sharedInstance].serverAddress.length > 0) {
        config.serverAddress = [SDKEnvConfig sharedInstance].serverAddress;
    }
    if ([SDKEnvConfig sharedInstance].serverPort > 0) {
        config.serverPort = [SDKEnvConfig sharedInstance].serverPort;
    }
    return config;
}

- (IBAction)initSDK:(id)sender {
    HWMOpenSDKConfig *config = [self getConfig];
    BOOL success = [HWMSdk initWithConfig:config];
    if (success) {
        NSLog(@"初始化成功");
        [UIUtil showMessage:@"初始化成功" vc:self];
        [self setCaVerify];
    }
}
- (IBAction)asyncInitSDK:(id)sender {
    HWMOpenSDKConfig *config = [self getConfig];
    [HWMSdk initAsyncWithConfig:config callback:^(HWMSDKERR errCode, id  _Nullable result) {
        if (errCode == HWMSDKSdkerrSuccess) {
            NSLog(@"子线程初始化成功");
            [UIUtil showMessage:@"子线程初始化成功" vc:self];
            [self setCaVerify];
        }
    }];
}

- (void)setCaVerify {
    HWMCaVerifyParam *param = [[HWMCaVerifyParam alloc] init];
    param.isVerify = [SDKEnvConfig sharedInstance].caVerify;
    [HWMSdk setCaVerifyParam:param];
}

@end
