//
//  LoginInputView.m
//  HWMSDKDemo
//
//  Created by l00465337 on 2020/8/11.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "LoginInputView.h"

static const CGFloat kContentMargin = 50;

@interface LoginInputView()
@property (nonatomic, weak) UILabel *titleLabel;
@property (nonatomic, weak) UITextField *inputTextField;
@end

@implementation LoginInputView

- (instancetype)init {
    if (self = [super init]) {
        [self createSubviews];
    }
    return self;
}

- (void)createSubviews {
    UILabel *titleLabel = [[UILabel alloc] init];
    [self addSubview:titleLabel];
    titleLabel.font = [UIFont systemFontOfSize:14];
    titleLabel.textColor = HexColor(0x666666);
    [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(kContentMargin);
        make.width.mas_equalTo(90);
        make.centerY.mas_equalTo(self);
        make.height.mas_equalTo(30);
    }];
    self.titleLabel = titleLabel;
    
    UITextField *inputTextField = [[UITextField alloc] init];
    [self addSubview:inputTextField];
    inputTextField.font = [UIFont systemFontOfSize:14];
    [inputTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(titleLabel.mas_right);
        make.right.mas_equalTo(-kContentMargin);
        make.centerY.mas_equalTo(self);
        make.height.mas_equalTo(30);
    }];
    self.inputTextField = inputTextField;
    
    UILabel * titleLineLabel = [[UILabel alloc] init];
    [self addSubview:titleLineLabel];
    titleLineLabel.backgroundColor = HexColor(0xf2f2f2);
    [titleLineLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.inputTextField.mas_bottom).mas_offset(1);
        make.height.mas_equalTo(1);
        make.left.right.mas_equalTo(self.inputTextField);
    }];
}

- (void)setTitle:(NSString *)title {
    _title = title;
    _titleLabel.text = title;
}

- (NSString *)content {
    return _inputTextField.text;
}

- (void)setContent:(NSString *)content {
    _inputTextField.text = content;
}

- (void)setPlaceholder:(NSString *)placeholder {
    _placeholder = placeholder;
    _inputTextField.placeholder = placeholder;
}

@end
