//
//  LoginManager.m
//  HWMSDKDemo
//
//  Created by yaolili/ywx577644 on 2023/9/12.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import "LoginManager.h"

@interface LoginManager ()

@property (nonatomic, assign) BOOL hasLogin;

@end

@implementation LoginManager

+ (instancetype)sharedInstance
{
    static id instance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[self alloc] init];
    });
    return instance;
}

- (void)updateHasLogin:(BOOL)hasLogin {
    self.hasLogin = hasLogin;
}

- (BOOL)hasLogin {
    return _hasLogin;
}

- (void)reset {
    self.hasLogin = NO;
}
@end
