//
//  LoginUtil.m
//  HWMSDKDemo
//
//  Created by l00465337 on 2020/8/10.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "LoginUtil.h"
#import <CommonCrypto/CommonCrypto.h>

@interface LoginUtil()
@property (nonatomic, strong) NSDictionary<NSNumber *,NSString *> *loginErrorDic;
@end

@implementation LoginUtil

+ (NSString *)HMACSHA256WithPlaintext:(NSString *)plaintext key:(NSString *)key {
    const char *cKey = [key cStringUsingEncoding:NSUTF8StringEncoding];
    const char *cData = [plaintext cStringUsingEncoding:NSUTF8StringEncoding];
    
    Byte shaBuffer[CC_SHA256_DIGEST_LENGTH] = {0};
    CCHmac(kCCHmacAlgSHA256, cKey, strlen(cKey), cData, strlen(cData), shaBuffer);
    NSData *shaData = [NSData dataWithBytes:shaBuffer length:CC_SHA256_DIGEST_LENGTH];
    
    NSMutableString *shaString = [NSMutableString stringWithCapacity:CC_SHA256_DIGEST_LENGTH*2];
    for (NSInteger i = 0; i < CC_SHA256_DIGEST_LENGTH; i++) {
        [shaString appendFormat:@"%02x", ((Byte *)shaData.bytes)[i]];
    }
    return [shaString copy];
}

@end
