//
//  AnonymousJoinConfBySignatureViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/g30033086 on 2023/9/18.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import "AnonymousJoinConfBySignatureViewController.h"
#import "UIUtil.h"
#import "LoginUtil.h"

@interface AnonymousJoinConfBySignatureViewController ()

@property (weak, nonatomic) IBOutlet UITextField *appIDTextFild;
@property (weak, nonatomic) IBOutlet UITextField *confIDTextField;
@property (weak, nonatomic) IBOutlet UITextField *pwdTextField;
@property (weak, nonatomic) IBOutlet UITextField *randomTextField;
@property (weak, nonatomic) IBOutlet UITextField *nameTextField;
@property (weak, nonatomic) IBOutlet UITextField *corpIdTextField;
@property (weak, nonatomic) IBOutlet UITextField *userIdTextField;
@property (weak, nonatomic) IBOutlet UITextField *signatureTextField;
@property (weak, nonatomic) IBOutlet UITextField *nonceTextField;
@property (weak, nonatomic) IBOutlet UITextField *expireTimeTextField;
@property (weak, nonatomic) IBOutlet UISwitch *micSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *camSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *spkSwitch;
@property (weak, nonatomic) IBOutlet UIButton *joinConfBtn;
@property (weak, nonatomic) IBOutlet UITextField *trackAppIDTextField;
@property (weak, nonatomic) IBOutlet UISwitch *supportLoginedJoinConfSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *isHidePasswordAlertSwitch;
@end

@implementation AnonymousJoinConfBySignatureViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self.joinConfBtn setDefaultButton];
    self.appIDTextFild.text = [SDKEnvConfig sharedInstance].appId;
    [self.view addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(endEdit)]];
}

- (IBAction)joinConf:(id)sender {
    HWMAppAuthInfo *appAuthInfo = [[HWMAppAuthInfo alloc] init];
    appAuthInfo.appId = self.appIDTextFild.text;
    appAuthInfo.corpId = self.corpIdTextField.text;
    appAuthInfo.userId = self.userIdTextField.text;
    appAuthInfo.signature = self.signatureTextField.text;
    appAuthInfo.nonce = self.nonceTextField.text;
    appAuthInfo.expireTime = [self.expireTimeTextField.text integerValue];
    
    HWMAnonymousJoinConfBySignatureInfo * anonymousJoinConfBySignatureInfo = [[HWMAnonymousJoinConfBySignatureInfo alloc] init];
    anonymousJoinConfBySignatureInfo.confId = self.confIDTextField.text;
    anonymousJoinConfBySignatureInfo.password = self.pwdTextField.text;
    anonymousJoinConfBySignatureInfo.confRandom = self.randomTextField.text;
    anonymousJoinConfBySignatureInfo.name = self.nameTextField.text;
    anonymousJoinConfBySignatureInfo.isMicOn = self.micSwitch.isOn;
    anonymousJoinConfBySignatureInfo.isCameraOn = self.camSwitch.isOn;
    anonymousJoinConfBySignatureInfo.isCloseSpk = !self.spkSwitch.isOn;
    anonymousJoinConfBySignatureInfo.appAuthInfo = appAuthInfo;
    anonymousJoinConfBySignatureInfo.corpTrustAppId = self.trackAppIDTextField.text;
    anonymousJoinConfBySignatureInfo.supportLoginedJoinConf = self.supportLoginedJoinConfSwitch.isOn;
    anonymousJoinConfBySignatureInfo.isHidePasswordAlert = self.isHidePasswordAlertSwitch.isOn;
    [[HWMSdk getPrivateApi] anonymousJoinConfBySignatureInfo:anonymousJoinConfBySignatureInfo passwordAlertEvent:^(HWMJionConfPasswordAlertEventType pwdEventType) {
    } callback:^(NSError *_Nonnull error) {
        if(error) {
            [UIUtil showMessage:[NSString stringWithFormat:@"加入会议:%zd %@", error.code, error.localizedDescription]];
        }
    }];
}

- (void)endEdit {
    [self.view endEditing:YES];
}

@end
