//
//  CTDConfViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/4/7.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "CTDConfViewController.h"
#import <HWMUISDK/HWMUISDK.h>

@interface CTDConfViewController ()

@property (nonatomic, strong) UITextField *calleeNumberTextField;
@property (nonatomic, strong) UITextField *calleeNickNameTextField;
@property (nonatomic, strong) UITextField *calleeCnNickNameTextField;
@property (nonatomic, strong) UITextField *calleeEnNickNameTextField;
@property (nonatomic, strong) UITextField *calleeExtendedFieldTextField;
@property (nonatomic, strong) UITextField *callerNumberTextField;
@property (nonatomic, strong) UITextField *callerNickNameTextField;
@property (nonatomic, strong) UITextField *callerCnNickNameTextField;
@property (nonatomic, strong) UITextField *callerEnNickNameTextField;
@property (nonatomic, strong) UITextField *callerExtendedFieldTextField;
@property (nonatomic, strong) UIScrollView *scrollView;
@property (nonatomic, strong) UISwitch *pwdSwitch;

@end

@implementation CTDConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"CTD回呼";
}

- (void)setupViews {
    [super setupViews];
    
    self.scrollView = [[UIScrollView alloc] init];
    [self.view addSubview:self.scrollView];
    [self.scrollView addTapAction:@selector(touchesBegan) target:self];
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.mas_equalTo(0);
        make.width.mas_equalTo(Screen_Width);
    }];
    
    self.calleeNumberTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeNumberTextField];
    self.calleeNumberTextField.placeholder = @"被叫号码";
    self.calleeNumberTextField.accessibilityIdentifier = HWMCallNumber;
    [self.calleeNumberTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_offset(50);
        make.height.mas_equalTo(30);
        make.leading.mas_equalTo(50);
        make.trailing.mas_equalTo(-50);
        make.width.mas_equalTo(Screen_Width - 100);
    }];
    [UIView addBottomLineWithView:self.calleeNumberTextField parentView:self.scrollView];
    
    self.calleeNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeNickNameTextField];
    self.calleeNickNameTextField.placeholder = @"被叫昵称";
    self.calleeNickNameTextField.accessibilityIdentifier = HWMCallNickName;
    [self.calleeNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeNumberTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.calleeNumberTextField);
    }];
    [UIView addBottomLineWithView:self.calleeNickNameTextField parentView:self.scrollView];
    
    self.calleeCnNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeCnNickNameTextField];
    self.calleeCnNickNameTextField.placeholder = @"被叫中文昵称";
    self.calleeCnNickNameTextField.accessibilityIdentifier = HWMCallCnNickName;
    [self.calleeCnNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeNickNameTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.calleeNickNameTextField);
    }];
    [UIView addBottomLineWithView:self.calleeCnNickNameTextField parentView:self.scrollView];
    
    self.calleeEnNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeEnNickNameTextField];
    self.calleeEnNickNameTextField.placeholder = @"被叫英文昵称";
    self.calleeEnNickNameTextField.accessibilityIdentifier = HWMCallEnNickName;
    [self.calleeEnNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeCnNickNameTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.calleeCnNickNameTextField);
    }];
    [UIView addBottomLineWithView:self.calleeEnNickNameTextField parentView:self.scrollView];
    
    self.calleeExtendedFieldTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeExtendedFieldTextField];
    self.calleeExtendedFieldTextField.placeholder = @"被叫扩展字段";
    self.calleeExtendedFieldTextField.accessibilityIdentifier = HWMCallExtendedField;
    [self.calleeExtendedFieldTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeEnNickNameTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.calleeEnNickNameTextField);
    }];
    [UIView addBottomLineWithView:self.calleeExtendedFieldTextField parentView:self.scrollView];
    
    self.callerNumberTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerNumberTextField];
    self.callerNumberTextField.placeholder = @"主叫号码";
    self.callerNumberTextField.accessibilityIdentifier = HWMCallNumber;
    [self.callerNumberTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeExtendedFieldTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.calleeExtendedFieldTextField);
    }];
    [UIView addBottomLineWithView:self.callerNumberTextField parentView:self.scrollView];
    
    self.callerNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerNickNameTextField];
    self.callerNickNameTextField.placeholder = @"主叫昵称";
    self.callerNickNameTextField.accessibilityIdentifier = HWMCallNickName;
    [self.callerNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerNumberTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.callerNumberTextField);
    }];
    [UIView addBottomLineWithView:self.callerNickNameTextField parentView:self.scrollView];
    
    self.callerCnNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerCnNickNameTextField];
    self.callerCnNickNameTextField.placeholder = @"主叫中文昵称";
    self.callerCnNickNameTextField.accessibilityIdentifier = HWMCallCnNickName;
    [self.callerCnNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerNickNameTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.callerNickNameTextField);
    }];
    [UIView addBottomLineWithView:self.callerCnNickNameTextField parentView:self.scrollView];
    
    self.callerEnNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerEnNickNameTextField];
    self.callerEnNickNameTextField.placeholder = @"主叫英文昵称";
    self.callerEnNickNameTextField.accessibilityIdentifier = HWMCallEnNickName;
    [self.callerEnNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerCnNickNameTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.callerCnNickNameTextField);
    }];
    [UIView addBottomLineWithView:self.callerEnNickNameTextField parentView:self.scrollView];
    
    self.callerExtendedFieldTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerExtendedFieldTextField];
    self.callerExtendedFieldTextField.placeholder = @"主叫扩展字段";
    self.callerExtendedFieldTextField.accessibilityIdentifier = HWMCallExtendedField;
    [self.callerExtendedFieldTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerEnNickNameTextField.mas_bottom).mas_offset(25);
        make.height.leading.trailing.mas_equalTo(self.callerEnNickNameTextField);
    }];
    [UIView addBottomLineWithView:self.callerExtendedFieldTextField parentView:self.scrollView];
    
    self.pwdSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.pwdSwitch];
    self.pwdSwitch.selected = NO;
    [self.pwdSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerExtendedFieldTextField.mas_bottom).mas_offset(20);
        make.trailing.mas_equalTo(self.callerExtendedFieldTextField);
    }];
    
    UILabel * pwdLabel = [self newLabelWithTitle:@"是否需要来宾密码"];
    [self.scrollView addSubview:pwdLabel];
    [pwdLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.mas_equalTo(self.callerExtendedFieldTextField);
        make.centerY.mas_equalTo(self.pwdSwitch);
    }];
    
    UIButton *callBtn = [UIButton newButtonWithTitle:@"发起回呼"];
    callBtn.accessibilityIdentifier = HWMCallCall;
    [self.scrollView addSubview:callBtn];
    [callBtn addTarget:self action:@selector(startCTDCall) forControlEvents:UIControlEventTouchUpInside];
    [callBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerExtendedFieldTextField.mas_bottom).mas_offset(50);
        make.leading.trailing.mas_equalTo(self.callerExtendedFieldTextField);
        make.height.mas_equalTo(50);
        make.bottom.mas_equalTo(-150);
    }];
}

- (void)touchesBegan {
    [self endEdit];
}

- (void)endEdit {
    [self.scrollView endEditing:YES];
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel * label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

- (void)startCTDCall {
    HWMAttendeeInfo *caller = [[HWMAttendeeInfo alloc] init];
    caller.number = self.callerNumberTextField.text;
    caller.name = self.callerNickNameTextField.text;
    caller.aliasCN = self.callerCnNickNameTextField.text;
    caller.aliasEN = self.callerEnNickNameTextField.text;
    caller.extendedField = self.callerExtendedFieldTextField.text;
    
    HWMAttendeeInfo *callee = [[HWMAttendeeInfo alloc] init];
    callee.number = self.calleeNumberTextField.text;
    callee.name = self.calleeNickNameTextField.text;
    callee.aliasCN = self.calleeCnNickNameTextField.text;
    callee.aliasEN = self.calleeEnNickNameTextField.text;
    callee.extendedField = self.calleeExtendedFieldTextField.text;
    
    HWMStartCTDCallParam *param = [[HWMStartCTDCallParam alloc] init];
    param.callerInfo = caller;
    param.calleeInfo = callee;
    param.isGuestJoinConfWithoutPwd = !self.pwdSwitch.isOn;
    [[HWMSdk getPrivateApi] startCTDCall:param callback:^(NSError * _Nullable error, HWMCreateConfResult * _Nullable result) {
        if (error) {
            [UIUtil showMessageWithError:error];
        } else {
            [UIUtil showMessage:[NSString stringWithFormat:@"发起回呼成功：%@", result.confId]];
        }
    }];
}

@end
